"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NowProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Used to synchronize time between parallel searches with relative time range that rely on `now`.
 */
class NowProvider {
  constructor() {
    // TODO: service shouldn't access params in the URL
    // instead it should be handled by apps
    (0, _defineProperty2.default)(this, "nowFromUrl", (0, _lib.getForceNowFromUrl)());
    (0, _defineProperty2.default)(this, "now", void 0);
  }
  get() {
    if (this.nowFromUrl) return this.nowFromUrl; // now forced from URL always takes precedence
    if (this.now) return this.now;
    return new Date();
  }
  set(now) {
    this.now = now;
  }
  reset() {
    this.now = undefined;
  }
}
exports.NowProvider = NowProvider;