"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.yearLabel = exports.secondLabel = exports.monthLabel = exports.minuteLabel = exports.millisecondLabel = exports.infinityLabel = exports.hourLabel = exports.dayLabel = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dayLabel = amount => _i18n.i18n.translate('data.search.timeBuckets.dayLabel', {
  defaultMessage: '{amount, plural, one {a day} other {# days}}',
  values: {
    amount
  }
});
exports.dayLabel = dayLabel;
const hourLabel = amount => _i18n.i18n.translate('data.search.timeBuckets.hourLabel', {
  defaultMessage: '{amount, plural, one {an hour} other {# hours}}',
  values: {
    amount
  }
});
exports.hourLabel = hourLabel;
const yearLabel = () => _i18n.i18n.translate('data.search.timeBuckets.yearLabel', {
  defaultMessage: 'a year'
});
exports.yearLabel = yearLabel;
const minuteLabel = amount => _i18n.i18n.translate('data.search.timeBuckets.minuteLabel', {
  defaultMessage: '{amount, plural, one {a minute} other {# minutes}}',
  values: {
    amount
  }
});
exports.minuteLabel = minuteLabel;
const secondLabel = amount => _i18n.i18n.translate('data.search.timeBuckets.secondLabel', {
  defaultMessage: '{amount, plural, one {a second} other {# seconds}}',
  values: {
    amount
  }
});
exports.secondLabel = secondLabel;
const millisecondLabel = amount => _i18n.i18n.translate('data.search.timeBuckets.millisecondLabel', {
  defaultMessage: '{amount, plural, one {a millisecond} other {# milliseconds}}',
  values: {
    amount
  }
});
exports.millisecondLabel = millisecondLabel;
const infinityLabel = () => _i18n.i18n.translate('data.search.timeBuckets.infinityLabel', {
  defaultMessage: 'More than a year'
});
exports.infinityLabel = infinityLabel;
const monthLabel = () => _i18n.i18n.translate('data.search.timeBuckets.monthLabel', {
  defaultMessage: 'a month'
});
exports.monthLabel = monthLabel;