"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggIpPrefixFnName = exports.aggIpPrefix = void 0;
var _i18n = require("@kbn/i18n");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const aggIpPrefixFnName = exports.aggIpPrefixFnName = 'aggIpPrefix';
const aggIpPrefix = () => ({
  name: aggIpPrefixFnName,
  help: _i18n.i18n.translate('data.search.aggs.function.buckets.ipPrefix.help', {
    defaultMessage: 'Generates a serialized agg config for a Ip Prefix agg'
  }),
  type: 'agg_type',
  args: {
    id: {
      types: ['string'],
      help: _i18n.i18n.translate('data.search.aggs.buckets.ipPrefix.id.help', {
        defaultMessage: 'ID for this aggregation'
      })
    },
    enabled: {
      types: ['boolean'],
      default: true,
      help: _i18n.i18n.translate('data.search.aggs.buckets.ipPrefix.enabled.help', {
        defaultMessage: 'Specifies whether this aggregation should be enabled'
      })
    },
    schema: {
      types: ['string'],
      help: _i18n.i18n.translate('data.search.aggs.buckets.ipPrefix.schema.help', {
        defaultMessage: 'Schema to use for this aggregation'
      })
    },
    field: {
      types: ['string'],
      required: true,
      help: _i18n.i18n.translate('data.search.aggs.buckets.ipPrefix.field.help', {
        defaultMessage: 'Field to use for this aggregation'
      })
    },
    ipPrefix: {
      types: ['ip_prefix'],
      help: _i18n.i18n.translate('data.search.aggs.buckets.ipPrefix.help', {
        defaultMessage: 'Length of the network prefix and whether it is for IPv4 or IPv6'
      })
    },
    json: {
      types: ['string'],
      help: _i18n.i18n.translate('data.search.aggs.buckets.ipPrefix.json.help', {
        defaultMessage: 'Advanced json to include when the agg is sent to Elasticsearch'
      })
    },
    customLabel: {
      types: ['string'],
      help: _i18n.i18n.translate('data.search.aggs.buckets.ipPrefix.customLabel.help', {
        defaultMessage: 'Represents a custom label for this aggregation'
      })
    }
  },
  fn: (input, {
    id,
    enabled,
    schema,
    ...params
  }) => {
    return {
      type: 'agg_type',
      value: {
        id,
        enabled,
        schema,
        type: _.BUCKET_TYPES.IP_PREFIX,
        params: {
          ...params
        }
      }
    };
  }
});
exports.aggIpPrefix = aggIpPrefix;