"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIpPrefixBucketAgg = void 0;
var _i18n = require("@kbn/i18n");
var _expressions = require("../../expressions");
var _bucket_agg_type = require("./bucket_agg_type");
var _bucket_agg_types = require("./bucket_agg_types");
var _ip_prefix = require("./create_filter/ip_prefix");
var _ip_prefix_fn = require("./ip_prefix_fn");
var _ = require("../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ipPrefixTitle = _i18n.i18n.translate('data.search.aggs.buckets.ipPrefixTitle', {
  defaultMessage: 'IP Prefix'
});
const getIpPrefixBucketAgg = () => new _bucket_agg_type.BucketAggType({
  name: _bucket_agg_types.BUCKET_TYPES.IP_PREFIX,
  expressionName: _ip_prefix_fn.aggIpPrefixFnName,
  title: ipPrefixTitle,
  createFilter: _ip_prefix.createFilterIpPrefix,
  getKey(bucket, key, agg) {
    return {
      type: 'ip_prefix',
      address: key,
      prefix_length: bucket.prefix_length
    };
  },
  getSerializedFormat(agg) {
    return {
      id: 'ip_prefix',
      params: agg.params.field ? agg.aggConfigs.indexPattern.getFormatterForField(agg.params.field).toJSON() : {}
    };
  },
  makeLabel(aggConfig) {
    return _i18n.i18n.translate('data.search.aggs.buckets.ipPrefixLabel', {
      defaultMessage: '{fieldName} IP prefixes',
      values: {
        fieldName: aggConfig.getFieldDisplayName()
      }
    });
  },
  params: [{
    name: 'field',
    type: 'field',
    filterFieldTypes: _.KBN_FIELD_TYPES.IP
  }, {
    name: 'ipPrefix',
    default: {
      prefixLength: 0,
      isIpv6: false
    },
    write: (aggConfig, output) => {
      output.params.prefix_length = aggConfig.params.ipPrefix.prefixLength;
      output.params.is_ipv6 = aggConfig.params.ipPrefix.isIpv6;
    },
    toExpressionAst: _expressions.ipPrefixToAst
  }]
});
exports.getIpPrefixBucketAgg = getIpPrefixBucketAgg;