"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedObjectsTaggingServiceFactory = void 0;
var _mocks = require("@kbn/saved-objects-tagging-oss-plugin/public/mocks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const savedObjectsTaggingServiceFactory = () => {
  const pluginMock = _mocks.taggingApiMock.createUi();
  return {
    hasApi: true,
    // I'm not defining components so that I don't have to update the snapshot of `save_modal.test`
    // However, if it's ever necessary, it can be done via: `components: pluginMock.components`,
    hasTagDecoration: pluginMock.hasTagDecoration,
    parseSearchQuery: pluginMock.parseSearchQuery,
    getSearchBarFilter: pluginMock.getSearchBarFilter,
    getTagIdsFromReferences: pluginMock.getTagIdsFromReferences,
    getTableColumnDefinition: pluginMock.getTableColumnDefinition
  };
};
exports.savedObjectsTaggingServiceFactory = savedObjectsTaggingServiceFactory;