"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDashboardMeta = void 0;
var _dashboard_constants = require("../../../dashboard_constants");
var _find_dashboards = require("./find_dashboards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const updateDashboardMeta = async ({
  id,
  title,
  description = '',
  tags
}, {
  contentManagement,
  savedObjectsTagging,
  embeddable
}) => {
  const [dashboard] = await (0, _find_dashboards.findDashboardsByIds)(contentManagement, [id]);
  if (dashboard.status === 'error') {
    return;
  }
  const references = savedObjectsTagging.updateTagsReferences && tags.length ? savedObjectsTagging.updateTagsReferences(dashboard.references, tags) : dashboard.references;
  await contentManagement.client.update({
    contentTypeId: _dashboard_constants.DASHBOARD_CONTENT_ID,
    id,
    data: {
      title,
      description
    },
    options: {
      references
    }
  });
};
exports.updateDashboardMeta = updateDashboardMeta;