"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardContentManagementServiceFactory = exports.dashboardContentManagementCache = void 0;
var _check_for_duplicate_dashboard_title = require("./lib/check_for_duplicate_dashboard_title");
var _find_dashboards = require("./lib/find_dashboards");
var _save_dashboard_state = require("./lib/save_dashboard_state");
var _delete_dashboards = require("./lib/delete_dashboards");
var _load_dashboard_state = require("./lib/load_dashboard_state");
var _update_dashboard_meta = require("./lib/update_dashboard_meta");
var _dashboard_content_management_cache = require("./dashboard_content_management_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardContentManagementCache = exports.dashboardContentManagementCache = new _dashboard_content_management_cache.DashboardContentManagementCache();
const dashboardContentManagementServiceFactory = ({
  startPlugins: {
    contentManagement
  }
}, requiredServices) => {
  const {
    data,
    embeddable,
    notifications,
    dashboardBackup,
    initializerContext,
    savedObjectsTagging
  } = requiredServices;
  return {
    loadDashboardState: ({
      id
    }) => (0, _load_dashboard_state.loadDashboardState)({
      id,
      data,
      embeddable,
      contentManagement,
      savedObjectsTagging
    }),
    saveDashboardState: ({
      currentState,
      saveOptions,
      lastSavedId,
      panelReferences
    }) => (0, _save_dashboard_state.saveDashboardState)({
      data,
      embeddable,
      saveOptions,
      lastSavedId,
      currentState,
      notifications,
      panelReferences,
      dashboardBackup,
      contentManagement,
      initializerContext,
      savedObjectsTagging
    }),
    findDashboards: {
      search: ({
        hasReference,
        hasNoReference,
        search,
        size,
        options
      }) => (0, _find_dashboards.searchDashboards)({
        contentManagement,
        hasNoReference,
        hasReference,
        options,
        search,
        size
      }),
      findById: id => (0, _find_dashboards.findDashboardById)(contentManagement, id),
      findByIds: ids => (0, _find_dashboards.findDashboardsByIds)(contentManagement, ids),
      findByTitle: title => (0, _find_dashboards.findDashboardIdByTitle)(contentManagement, title)
    },
    checkForDuplicateDashboardTitle: props => (0, _check_for_duplicate_dashboard_title.checkForDuplicateDashboardTitle)(props, contentManagement),
    deleteDashboards: ids => (0, _delete_dashboards.deleteDashboards)(ids, contentManagement),
    updateDashboardMeta: props => (0, _update_dashboard_meta.updateDashboardMeta)(props, {
      contentManagement,
      savedObjectsTagging,
      embeddable
    })
  };
};
exports.dashboardContentManagementServiceFactory = dashboardContentManagementServiceFactory;