"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardListingTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _ebtTools = require("@kbn/ebt-tools");
var _dashboard_constants = require("../../dashboard_constants");
var _dashboard_listing_strings = require("../_dashboard_listing_strings");
var _confirm_overlays = require("../confirm_overlays");
var _plugin_services = require("../../services/plugin_services");
var _dashboard_listing_empty_prompt = require("../dashboard_listing_empty_prompt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SAVED_OBJECTS_LIMIT_SETTING = 'savedObjects:listingLimit';
const SAVED_OBJECTS_PER_PAGE_SETTING = 'savedObjects:perPage';
const toTableListViewSavedObject = hit => {
  const {
    title,
    description,
    timeRestore
  } = hit.attributes;
  return {
    type: 'dashboard',
    id: hit.id,
    updatedAt: hit.updatedAt,
    createdAt: hit.createdAt,
    createdBy: hit.createdBy,
    updatedBy: hit.updatedBy,
    references: hit.references,
    managed: hit.managed,
    attributes: {
      title,
      description,
      timeRestore
    }
  };
};
const useDashboardListingTable = ({
  dashboardListingId = 'dashboard',
  disableCreateDashboardButton,
  getDashboardUrl,
  goToDashboard,
  headingId = 'dashboardListingHeading',
  initialFilter,
  urlStateEnabled,
  useSessionStorageIntegration,
  showCreateDashboardButton = true
}) => {
  const {
    dashboardBackup,
    dashboardCapabilities: {
      showWriteControls
    },
    settings: {
      uiSettings
    },
    dashboardContentManagement: {
      findDashboards,
      deleteDashboards,
      updateDashboardMeta,
      checkForDuplicateDashboardTitle
    },
    notifications: {
      toasts
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    getEntityName,
    getTableListTitle,
    getEntityNamePlural
  } = _dashboard_listing_strings.dashboardListingTableStrings;
  const title = getTableListTitle();
  const entityName = getEntityName();
  const entityNamePlural = getEntityNamePlural();
  const [pageDataTestSubject, setPageDataTestSubject] = (0, _react.useState)();
  const [hasInitialFetchReturned, setHasInitialFetchReturned] = (0, _react.useState)(false);
  const [unsavedDashboardIds, setUnsavedDashboardIds] = (0, _react.useState)(dashboardBackup.getDashboardIdsWithUnsavedChanges());
  const listingLimit = uiSettings.get(SAVED_OBJECTS_LIMIT_SETTING);
  const initialPageSize = uiSettings.get(SAVED_OBJECTS_PER_PAGE_SETTING);
  const createItem = (0, _react.useCallback)(() => {
    if (useSessionStorageIntegration && dashboardBackup.dashboardHasUnsavedEdits()) {
      (0, _confirm_overlays.confirmCreateWithUnsaved)(() => {
        dashboardBackup.clearState();
        goToDashboard();
      }, goToDashboard);
      return;
    }
    goToDashboard();
  }, [dashboardBackup, goToDashboard, useSessionStorageIntegration]);
  const updateItemMeta = (0, _react.useCallback)(async props => {
    await updateDashboardMeta(props);
    setUnsavedDashboardIds(dashboardBackup.getDashboardIdsWithUnsavedChanges());
  }, [dashboardBackup, updateDashboardMeta]);
  const contentEditorValidators = (0, _react.useMemo)(() => ({
    title: [{
      type: 'warning',
      fn: async (value, id) => {
        if (id) {
          try {
            const [dashboard] = await findDashboards.findByIds([id]);
            if (dashboard.status === 'error') {
              return;
            }
            const validTitle = await checkForDuplicateDashboardTitle({
              title: value,
              copyOnSave: false,
              lastSavedTitle: dashboard.attributes.title,
              isTitleDuplicateConfirmed: false
            });
            if (!validTitle) {
              throw new Error(_dashboard_listing_strings.dashboardListingErrorStrings.getDuplicateTitleWarning(value));
            }
          } catch (e) {
            return e.message;
          }
        }
      }
    }]
  }), [checkForDuplicateDashboardTitle, findDashboards]);
  const emptyPrompt = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_dashboard_listing_empty_prompt.DashboardListingEmptyPrompt, {
    createItem: createItem,
    disableCreateDashboardButton: disableCreateDashboardButton,
    goToDashboard: goToDashboard,
    setUnsavedDashboardIds: setUnsavedDashboardIds,
    unsavedDashboardIds: unsavedDashboardIds,
    useSessionStorageIntegration: useSessionStorageIntegration
  }), [createItem, disableCreateDashboardButton, goToDashboard, unsavedDashboardIds, useSessionStorageIntegration]);
  const findItems = (0, _react.useCallback)((searchTerm, {
    references,
    referencesToExclude
  } = {}) => {
    const searchStartTime = window.performance.now();
    return findDashboards.search({
      search: searchTerm,
      size: listingLimit,
      hasReference: references,
      hasNoReference: referencesToExclude
    }).then(({
      total,
      hits
    }) => {
      const searchEndTime = window.performance.now();
      const searchDuration = searchEndTime - searchStartTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(_plugin_services.pluginServices.getServices().analytics, {
        eventName: _dashboard_constants.SAVED_OBJECT_LOADED_TIME,
        duration: searchDuration,
        meta: {
          saved_object_type: _dashboard_constants.DASHBOARD_CONTENT_ID
        }
      });
      return {
        total,
        hits: hits.map(toTableListViewSavedObject)
      };
    });
  }, [findDashboards, listingLimit]);
  const deleteItems = (0, _react.useCallback)(async dashboardsToDelete => {
    try {
      const deleteStartTime = window.performance.now();
      await deleteDashboards(dashboardsToDelete.map(({
        id
      }) => {
        dashboardBackup.clearState(id);
        return id;
      }));
      const deleteDuration = window.performance.now() - deleteStartTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(_plugin_services.pluginServices.getServices().analytics, {
        eventName: _dashboard_constants.SAVED_OBJECT_DELETE_TIME,
        duration: deleteDuration,
        meta: {
          saved_object_type: _dashboard_constants.DASHBOARD_CONTENT_ID,
          total: dashboardsToDelete.length
        }
      });
    } catch (error) {
      toasts.addError(error, {
        title: _dashboard_listing_strings.dashboardListingErrorStrings.getErrorDeletingDashboardToast()
      });
    }
    setUnsavedDashboardIds(dashboardBackup.getDashboardIdsWithUnsavedChanges());
  }, [dashboardBackup, deleteDashboards, toasts]);
  const editItem = (0, _react.useCallback)(({
    id
  }) => goToDashboard(id, _public.ViewMode.EDIT), [goToDashboard]);
  const onFetchSuccess = (0, _react.useCallback)(() => {
    if (!hasInitialFetchReturned) {
      setHasInitialFetchReturned(true);
    }
  }, [hasInitialFetchReturned]);
  const getDetailViewLink = (0, _react.useCallback)(({
    id,
    attributes: {
      timeRestore
    }
  }) => getDashboardUrl(id, timeRestore), [getDashboardUrl]);
  const tableListViewTableProps = (0, _react.useMemo)(() => ({
    contentEditor: {
      isReadonly: !showWriteControls,
      onSave: updateItemMeta,
      customValidators: contentEditorValidators,
      showActivityView: true
    },
    createItem: !showWriteControls || !showCreateDashboardButton ? undefined : createItem,
    deleteItems: !showWriteControls ? undefined : deleteItems,
    editItem: !showWriteControls ? undefined : editItem,
    emptyPrompt,
    entityName,
    entityNamePlural,
    findItems,
    getDetailViewLink,
    headingId,
    id: dashboardListingId,
    initialFilter,
    initialPageSize,
    listingLimit,
    onFetchSuccess,
    setPageDataTestSubject,
    title,
    urlStateEnabled,
    createdByEnabled: true
  }), [contentEditorValidators, createItem, dashboardListingId, deleteItems, editItem, emptyPrompt, entityName, entityNamePlural, findItems, getDetailViewLink, headingId, initialFilter, initialPageSize, listingLimit, onFetchSuccess, showCreateDashboardButton, showWriteControls, title, updateItemMeta, urlStateEnabled]);
  const refreshUnsavedDashboards = (0, _react.useCallback)(() => setUnsavedDashboardIds(dashboardBackup.getDashboardIdsWithUnsavedChanges()), [dashboardBackup]);
  return {
    hasInitialFetchReturned,
    pageDataTestSubject,
    refreshUnsavedDashboards,
    tableListViewTableProps,
    unsavedDashboardIds
  };
};
exports.useDashboardListingTable = useDashboardListingTable;