"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardContainerReducers = void 0;
var _public = require("@kbn/embeddable-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardContainerReducers = exports.dashboardContainerReducers = {
  // ------------------------------------------------------------------------------
  // Content Reducers
  // ------------------------------------------------------------------------------
  setPanels: (state, action) => {
    state.explicitInput.panels = action.payload;
  },
  // ------------------------------------------------------------------------------
  // Meta info Reducers
  // ------------------------------------------------------------------------------
  setStateFromSaveModal: (state, action) => {
    state.componentState.lastSavedId = action.payload.lastSavedId;
    state.explicitInput.tags = action.payload.tags;
    state.explicitInput.title = action.payload.title;
    state.explicitInput.description = action.payload.description;
    state.explicitInput.timeRestore = action.payload.timeRestore;
    if (action.payload.refreshInterval) {
      state.explicitInput.refreshInterval = action.payload.refreshInterval;
    }
    if (action.payload.timeRange) {
      state.explicitInput.timeRange = action.payload.timeRange;
    }
  },
  setLastSavedId: (state, action) => {
    state.componentState.lastSavedId = action.payload;
  },
  setStateFromSettingsFlyout: (state, action) => {
    state.componentState.lastSavedId = action.payload.lastSavedId;
    state.explicitInput.tags = action.payload.tags;
    state.explicitInput.title = action.payload.title;
    state.explicitInput.description = action.payload.description;
    state.explicitInput.timeRestore = action.payload.timeRestore;
    state.explicitInput.useMargins = action.payload.useMargins;
    state.explicitInput.syncColors = action.payload.syncColors;
    state.explicitInput.syncCursor = action.payload.syncCursor;
    state.explicitInput.syncTooltips = action.payload.syncTooltips;
    state.explicitInput.hidePanelTitles = action.payload.hidePanelTitles;
  },
  setDescription: (state, action) => {
    state.explicitInput.description = action.payload;
  },
  setViewMode: (state, action) => {
    // Managed Dashboards cannot be put into edit mode.
    if (state.componentState.managed) {
      state.explicitInput.viewMode = _public.ViewMode.VIEW;
      return;
    }
    state.explicitInput.viewMode = action.payload;
  },
  setTags: (state, action) => {
    state.explicitInput.tags = action.payload;
  },
  setTitle: (state, action) => {
    state.explicitInput.title = action.payload;
  },
  setManaged: (state, action) => {
    state.componentState.managed = action.payload;
  },
  // ------------------------------------------------------------------------------
  // Unsaved Changes Reducers
  // ------------------------------------------------------------------------------
  setHasUnsavedChanges: (state, action) => {
    state.componentState.hasUnsavedChanges = action.payload;
  },
  setLastSavedInput: (state, action) => {
    state.componentState.lastSavedInput = action.payload;

    // if we set the last saved input, it means we have saved this Dashboard - therefore clientside migrations have
    // been serialized into the SO.
    state.componentState.hasRunClientsideMigrations = false;
  },
  /**
   * Resets the dashboard to the last saved input, excluding:
   * 1) The time range, unless `timeRestore` is `true` - if we include the time range on reset even when
   *    `timeRestore` is `false`, this causes unecessary data fetches for the control group.
   * 2) The view mode, since resetting should never impact this - sometimes the Dashboard saved objects
   *    have this saved in and we don't want resetting to cause unexpected view mode changes.
   */
  resetToLastSavedInput: state => {
    state.explicitInput = {
      ...state.componentState.lastSavedInput,
      ...(!state.explicitInput.timeRestore && {
        timeRange: state.explicitInput.timeRange
      }),
      viewMode: state.explicitInput.viewMode
    };
  },
  // ------------------------------------------------------------------------------
  // Filtering Reducers
  // ------------------------------------------------------------------------------
  setFiltersAndQuery: (state, action) => {
    state.explicitInput.filters = action.payload.filters;
    state.explicitInput.query = action.payload.query;
  },
  setLastReloadRequestTimeToNow: state => {
    state.explicitInput.lastReloadRequestTime = new Date().getTime();
  },
  setFilters: (state, action) => {
    state.explicitInput.filters = action.payload;
  },
  setQuery: (state, action) => {
    state.explicitInput.query = action.payload;
  },
  setSavedQueryId: (state, action) => {
    state.componentState.savedQueryId = action.payload;
  },
  setTimeRestore: (state, action) => {
    state.explicitInput.timeRestore = action.payload;
  },
  setTimeRange: (state, action) => {
    state.explicitInput.timeRange = action.payload;
  },
  setRefreshInterval: (state, action) => {
    state.explicitInput.refreshInterval = action.payload;
  },
  setTimeslice: (state, action) => {
    state.explicitInput.timeslice = action.payload;
  },
  setExpandedPanelId: (state, action) => {
    state.componentState.expandedPanelId = action.payload;
  },
  setFullScreenMode: (state, action) => {
    state.componentState.fullScreenMode = action.payload;
  },
  // ------------------------------------------------------------------------------
  // Component state reducers
  // ------------------------------------------------------------------------------

  setHasOverlays: (state, action) => {
    state.componentState.hasOverlays = action.payload;
  },
  setScrollToPanelId: (state, action) => {
    state.componentState.scrollToPanelId = action.payload;
  },
  setHighlightPanelId: (state, action) => {
    state.componentState.highlightPanelId = action.payload;
  },
  setFocusedPanelId: (state, action) => {
    state.componentState.focusedPanelId = action.payload;
  },
  setAnimatePanelTransforms: (state, action) => {
    state.componentState.animatePanelTransforms = action.payload;
  }
};