"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.placePanel = placePanel;
exports.providesLegacyPanelPlacementSettings = void 0;
var _place_new_panel_strategies = require("./place_new_panel_strategies");
var _dashboard_constants = require("../../dashboard_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const providesLegacyPanelPlacementSettings = value => {
  return Boolean(value.getLegacyPanelPlacementSettings);
};
exports.providesLegacyPanelPlacementSettings = providesLegacyPanelPlacementSettings;
function placePanel(factory, newPanel, currentPanels, attributes) {
  let placementSettings = {
    width: _dashboard_constants.DEFAULT_PANEL_WIDTH,
    height: _dashboard_constants.DEFAULT_PANEL_HEIGHT,
    strategy: _dashboard_constants.PanelPlacementStrategy.findTopLeftMostOpenSpace
  };
  if (providesLegacyPanelPlacementSettings(factory)) {
    placementSettings = {
      ...placementSettings,
      ...factory.getLegacyPanelPlacementSettings(newPanel.explicitInput, attributes)
    };
  }
  const {
    width,
    height,
    strategy
  } = placementSettings;
  const {
    newPanelPlacement,
    otherPanels
  } = (0, _place_new_panel_strategies.runPanelPlacementStrategy)(strategy, {
    currentPanels,
    height,
    width
  });
  return {
    newPanel: {
      gridData: {
        ...newPanelPlacement,
        i: newPanel.explicitInput.id
      },
      ...newPanel
    },
    otherPanels
  };
}