"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildApiFromDashboardContainer = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// TODO lock down DashboardAPI

const buildApiFromDashboardContainer = container => container !== null && container !== void 0 ? container : null;

/**
 * An interface that holds types for the methods that Dashboard publishes which should not be used
 * outside of the Dashboard plugin. This is necessary for some actions which reside in the Dashboard plugin.
 */
exports.buildApiFromDashboardContainer = buildApiFromDashboardContainer;