"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardTypeDisplayName = exports.dashboardTypeDisplayLowercase = exports.DashboardContainerFactoryDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _ = require("..");
var _common = require("../../../common");
var _dashboard_constants = require("../../dashboard_constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const dashboardTypeDisplayName = exports.dashboardTypeDisplayName = _i18n.i18n.translate('dashboard.factory.displayName', {
  defaultMessage: 'Dashboard'
});
const dashboardTypeDisplayLowercase = exports.dashboardTypeDisplayLowercase = _i18n.i18n.translate('dashboard.factory.displayNameLowercase', {
  defaultMessage: 'dashboard'
});
class DashboardContainerFactoryDefinition {
  constructor(persistableStateService) {
    (0, _defineProperty2.default)(this, "isContainerType", true);
    (0, _defineProperty2.default)(this, "type", _.DASHBOARD_CONTAINER_TYPE);
    (0, _defineProperty2.default)(this, "inject", void 0);
    (0, _defineProperty2.default)(this, "extract", void 0);
    (0, _defineProperty2.default)(this, "isEditable", async () => {
      // Currently unused for dashboards
      return false;
    });
    (0, _defineProperty2.default)(this, "getDisplayName", () => dashboardTypeDisplayName);
    (0, _defineProperty2.default)(this, "create", async (initialInput, parent, creationOptions, savedObjectId) => {
      const dashboardCreationStartTime = performance.now();
      const {
        createDashboard
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./create/create_dashboard')));
      try {
        const dashboard = await createDashboard(creationOptions, dashboardCreationStartTime, savedObjectId);
        return dashboard;
      } catch (e) {
        return new _public.ErrorEmbeddable(e, {
          id: e.id
        });
      }
    });
    this.persistableStateService = persistableStateService;
    this.inject = (0, _common.createInject)(this.persistableStateService);
    this.extract = (0, _common.createExtract)(this.persistableStateService);
  }
  getDefaultInput() {
    return _dashboard_constants.DEFAULT_DASHBOARD_INPUT;
  }
}
exports.DashboardContainerFactoryDefinition = DashboardContainerFactoryDefinition;