"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newSession$ = newSession$;
var _esQuery = require("@kbn/es-query");
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _publishes_settings = require("@kbn/presentation-containers/interfaces/publishes_settings");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _dashboard_diffing_utils = require("../../../state/diffing/dashboard_diffing_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function newSession$(api) {
  const observables = [];
  if ((0, _presentationPublishing.apiPublishesUnifiedSearch)(api)) {
    observables.push(api.filters$.pipe(
    // TODO move onlyDisabledFiltersChanged to appliedFilters$ interface
    (0, _rxjs.distinctUntilChanged)((previous, current) => {
      return (0, _esQuery.onlyDisabledFiltersChanged)(previous, current, _public.shouldRefreshFilterCompareOptions);
    })));
    observables.push(api.query$);
    observables.push(api.timeRange$.pipe((0, _rxjs.distinctUntilChanged)((previous, current) => {
      return (0, _dashboard_diffing_utils.areTimesEqual)(current === null || current === void 0 ? void 0 : current.from, previous === null || previous === void 0 ? void 0 : previous.from) && (0, _dashboard_diffing_utils.areTimesEqual)(current === null || current === void 0 ? void 0 : current.to, previous === null || previous === void 0 ? void 0 : previous.to);
    })));
    if (api.timeRestore$) {
      observables.push(api.timeRestore$);
    }
    if (api.timeslice$) {
      observables.push(api.timeslice$);
    }
  }
  if ((0, _publishes_settings.apiPublishesSettings)(api)) {
    if (api.settings.syncColors$) {
      observables.push(api.settings.syncColors$);
    }
    if (api.settings.syncCursor$) {
      observables.push(api.settings.syncCursor$);
    }
    if (api.settings.syncTooltips$) {
      observables.push(api.settings.syncTooltips$);
    }
  }

  // TODO replace lastReloadRequestTime$ with reload$ when removing legacy embeddable framework
  if (api.lastReloadRequestTime$) {
    observables.push(api.lastReloadRequestTime$);
  }
  return (0, _rxjs.combineLatest)(observables).pipe((0, _rxjs.skip)(1));
}