"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startQueryPerformanceTracking = void 0;
var _ebtTools = require("@kbn/ebt-tools");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _dashboard_constants = require("../../../../dashboard_constants");
var _plugin_services = require("../../../../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let isFirstDashboardLoadOfSession = true;
const loadTypesMapping = {
  sessionFirstLoad: 0,
  dashboardFirstLoad: 1,
  dashboardSubsequentLoad: 2
};
const startQueryPerformanceTracking = dashboard => {
  const {
    analytics
  } = _plugin_services.pluginServices.getServices();
  const reportPerformanceMetrics = ({
    timeToData,
    panelCount,
    totalLoadTime,
    loadType
  }) => {
    const duration = loadType === 'dashboardSubsequentLoad' ? timeToData : Math.max(timeToData, totalLoadTime);
    (0, _ebtTools.reportPerformanceMetricEvent)(analytics, {
      eventName: _dashboard_constants.DASHBOARD_LOADED_EVENT,
      duration,
      key1: 'time_to_data',
      value1: timeToData,
      key2: 'num_of_panels',
      value2: panelCount,
      key4: 'load_type',
      value4: loadTypesMapping[loadType]
    });
  };
  return dashboard.children$.pipe((0, _rxjs.switchMap)(children => {
    const childPhaseEventTrackers = [];
    for (const child of Object.values(children)) {
      if ((0, _presentationPublishing.apiPublishesPhaseEvents)(child)) childPhaseEventTrackers.push(child);
    }
    if (childPhaseEventTrackers.length === 0) return (0, _rxjs.of)([]);
    return (0, _rxjs.combineLatest)(childPhaseEventTrackers.map(child => child.phase$));
  }), (0, _rxjs.map)(latestPhaseEvents => latestPhaseEvents.some(phaseEvent => phaseEvent && phaseEvent.status !== 'rendered')), (0, _rxjs.startWith)(false), (0, _rxjs.pairwise)()).subscribe(([lastLoading, currentLoading]) => {
    const panelCount = dashboard.getPanelCount();
    const now = performance.now();
    const loadType = isFirstDashboardLoadOfSession ? 'sessionFirstLoad' : dashboard.firstLoad ? 'dashboardFirstLoad' : 'dashboardSubsequentLoad';
    const queryHasStarted = !lastLoading && currentLoading;
    const queryHasFinished = lastLoading && !currentLoading;
    if (dashboard.firstLoad && (panelCount === 0 || queryHasFinished)) {
      /**
       * we consider the Dashboard creation to be finished when all the panels are loaded.
       */
      dashboard.creationEndTime = now;
      isFirstDashboardLoadOfSession = false;
      dashboard.firstLoad = false;
    }
    if (queryHasStarted) {
      dashboard.lastLoadStartTime = now;
      return;
    }
    if (queryHasFinished) {
      var _dashboard$lastLoadSt, _dashboard$creationEn, _dashboard$creationSt;
      const timeToData = now - ((_dashboard$lastLoadSt = dashboard.lastLoadStartTime) !== null && _dashboard$lastLoadSt !== void 0 ? _dashboard$lastLoadSt : now);
      const completeLoadDuration = ((_dashboard$creationEn = dashboard.creationEndTime) !== null && _dashboard$creationEn !== void 0 ? _dashboard$creationEn : now) - ((_dashboard$creationSt = dashboard.creationStartTime) !== null && _dashboard$creationSt !== void 0 ? _dashboard$creationSt : now);
      reportPerformanceMetrics({
        timeToData,
        panelCount,
        totalLoadTime: completeLoadDuration,
        loadType
      });
    }
  });
};
exports.startQueryPerformanceTracking = startQueryPerformanceTracking;