"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.duplicateDashboardPanel = duplicateDashboardPanel;
exports.incrementPanelTitle = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _serialized_state = require("@kbn/presentation-containers/interfaces/serialized_state");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
var _uuid = require("uuid");
var _common = require("../../../../common");
var _dashboard_actions_strings = require("../../../dashboard_actions/_dashboard_actions_strings");
var _plugin_services = require("../../../services/plugin_services");
var _panel_placement = require("../../panel_placement");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const duplicateLegacyInput = async (dashboard, panelToClone, idToDuplicate) => {
  const embeddable = dashboard.getChild(idToDuplicate);
  if (!panelToClone || !embeddable) throw new _public.PanelNotFoundError();
  const newTitle = await incrementPanelTitle(dashboard, embeddable.getTitle() || '');
  const id = (0, _uuid.v4)();
  if ((0, _public.isReferenceOrValueEmbeddable)(embeddable)) {
    return {
      type: embeddable.type,
      explicitInput: {
        ...(await embeddable.getInputAsValueType()),
        hidePanelTitles: panelToClone.explicitInput.hidePanelTitles,
        ...(newTitle ? {
          title: newTitle
        } : {}),
        id
      }
    };
  }
  return {
    type: embeddable.type,
    explicitInput: {
      ...panelToClone.explicitInput,
      title: newTitle,
      id
    }
  };
};
const duplicateReactEmbeddableInput = async (dashboard, panelToClone, idToDuplicate) => {
  var _getPanelTitle;
  const id = (0, _uuid.v4)();
  const child = dashboard.children$.value[idToDuplicate];
  const lastTitle = (0, _presentationPublishing.apiPublishesPanelTitle)(child) ? (_getPanelTitle = (0, _presentationPublishing.getPanelTitle)(child)) !== null && _getPanelTitle !== void 0 ? _getPanelTitle : '' : '';
  const newTitle = await incrementPanelTitle(dashboard, lastTitle);

  /**
   * For react embeddables that have library transforms, we need to ensure
   * to clone them with serialized state and references.
   *
   * TODO: remove this section once all by reference capable react embeddables
   * use in-place library transforms
   */
  if ((0, _presentationPublishing.apiHasLibraryTransforms)(child)) {
    const byValueSerializedState = await child.getByValueState();
    if (panelToClone.references) {
      dashboard.savedObjectReferences.push(...(0, _common.prefixReferencesFromPanel)(id, panelToClone.references));
    }
    return {
      type: panelToClone.type,
      explicitInput: {
        ...byValueSerializedState,
        title: newTitle,
        id
      }
    };
  }
  const runtimeSnapshot = (() => {
    if ((0, _presentationPublishing.apiHasInPlaceLibraryTransforms)(child)) return child.getByValueRuntimeSnapshot();
    return (0, _serialized_state.apiHasSnapshottableState)(child) ? child.snapshotRuntimeState() : {};
  })();
  if ((0, _presentationPublishing.stateHasTitles)(runtimeSnapshot)) runtimeSnapshot.title = newTitle;
  dashboard.setRuntimeStateForChild(id, runtimeSnapshot);
  return {
    type: panelToClone.type,
    explicitInput: {
      id
    }
  };
};
async function duplicateDashboardPanel(idToDuplicate) {
  const {
    notifications: {
      toasts
    },
    embeddable: {
      reactEmbeddableRegistryHasKey
    }
  } = _plugin_services.pluginServices.getServices();
  const panelToClone = await this.getDashboardPanelFromId(idToDuplicate);
  const duplicatedPanelState = reactEmbeddableRegistryHasKey(panelToClone.type) ? await duplicateReactEmbeddableInput(this, panelToClone, idToDuplicate) : await duplicateLegacyInput(this, panelToClone, idToDuplicate);
  toasts.addSuccess({
    title: _dashboard_actions_strings.dashboardClonePanelActionStrings.getSuccessMessage(),
    'data-test-subj': 'addObjectToContainerSuccess'
  });
  const {
    newPanelPlacement,
    otherPanels
  } = (0, _panel_placement.placeClonePanel)({
    width: panelToClone.gridData.w,
    height: panelToClone.gridData.h,
    currentPanels: this.getInput().panels,
    placeBesideId: panelToClone.explicitInput.id
  });
  const newPanel = {
    ...duplicatedPanelState,
    gridData: {
      ...newPanelPlacement,
      i: duplicatedPanelState.explicitInput.id
    }
  };
  this.updateInput({
    panels: {
      ...otherPanels,
      [newPanel.explicitInput.id]: newPanel
    }
  });
}
const incrementPanelTitle = async (dashboard, rawTitle) => {
  if (rawTitle === '') return '';
  const clonedTag = _dashboard_actions_strings.dashboardClonePanelActionStrings.getClonedTag();
  const cloneRegex = new RegExp(`\\(${clonedTag}\\)`, 'g');
  const cloneNumberRegex = new RegExp(`\\(${clonedTag} [0-9]+\\)`, 'g');
  const baseTitle = rawTitle.replace(cloneNumberRegex, '').replace(cloneRegex, '').trim();
  const similarTitles = (0, _lodash.filter)(await dashboard.getPanelTitles(), title => {
    return title.startsWith(baseTitle);
  });
  const cloneNumbers = (0, _lodash.map)(similarTitles, title => {
    if (title.match(cloneRegex)) return 0;
    const cloneTag = title.match(cloneNumberRegex);
    return cloneTag ? parseInt(cloneTag[0].replace(/[^0-9.]/g, ''), 10) : -1;
  });
  const similarBaseTitlesCount = (0, _lodash.max)(cloneNumbers) || 0;
  return similarBaseTitlesCount < 0 ? baseTitle + ` (${clonedTag})` : baseTitle + ` (${clonedTag} ${similarBaseTitlesCount + 1})`;
};
exports.incrementPanelTitle = incrementPanelTitle;