"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservedItem = exports.Item = exports.DashboardGridItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _public = require("@kbn/embeddable-plugin/public");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = _interopRequireWildcard(require("react"));
var _plugin_services = require("../../../services/plugin_services");
var _dashboard_container = require("../../embeddable/dashboard_container");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Item = exports.Item = /*#__PURE__*/_react2.default.forwardRef(({
  expandedPanelId,
  focusedPanelId,
  id,
  index,
  type,
  isRenderable = true,
  // The props below are passed from ReactGridLayoutn and need to be merged with their counterparts.
  // https://github.com/react-grid-layout/react-grid-layout/issues/1241#issuecomment-658306889
  children,
  className,
  ...rest
}, ref) => {
  const container = (0, _dashboard_container.useDashboardContainer)();
  const scrollToPanelId = container.select(state => state.componentState.scrollToPanelId);
  const highlightPanelId = container.select(state => state.componentState.highlightPanelId);
  const useMargins = container.select(state => state.explicitInput.useMargins);
  const expandPanel = expandedPanelId !== undefined && expandedPanelId === id;
  const hidePanel = expandedPanelId !== undefined && expandedPanelId !== id;
  const focusPanel = focusedPanelId !== undefined && focusedPanelId === id;
  const blurPanel = focusedPanelId !== undefined && focusedPanelId !== id;
  const classes = (0, _classnames.default)({
    'dshDashboardGrid__item--expanded': expandPanel,
    'dshDashboardGrid__item--hidden': hidePanel,
    'dshDashboardGrid__item--focused': focusPanel,
    'dshDashboardGrid__item--blurred': blurPanel,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    printViewport__vis: container.getInput().viewMode === _public.ViewMode.PRINT
  });
  (0, _react2.useLayoutEffect)(() => {
    if (typeof ref !== 'function' && ref !== null && ref !== void 0 && ref.current) {
      const panelRef = ref.current;
      if (scrollToPanelId === id) {
        container.scrollToPanel(panelRef);
      }
      if (highlightPanelId === id) {
        container.highlightPanel(panelRef);
      }
      panelRef.querySelectorAll('*').forEach(e => {
        if (blurPanel) {
          // remove blurred panels and nested elements from tab order
          e.setAttribute('tabindex', '-1');
        } else {
          // restore tab order
          e.removeAttribute('tabindex');
        }
      });
    }
  }, [id, container, scrollToPanelId, highlightPanelId, ref, blurPanel]);
  const focusStyles = blurPanel ? (0, _react.css)`
          pointer-events: none;
          opacity: 0.25;
        ` : undefined;
  const renderedEmbeddable = (0, _react2.useMemo)(() => {
    const {
      embeddable: {
        reactEmbeddableRegistryHasKey
      }
    } = _plugin_services.pluginServices.getServices();
    const panelProps = {
      showBadges: true,
      showBorder: useMargins,
      showNotifications: true,
      showShadow: false
    };

    // render React embeddable
    if (reactEmbeddableRegistryHasKey(type)) {
      return /*#__PURE__*/_react2.default.createElement(_public.ReactEmbeddableRenderer, {
        type: type,
        maybeId: id,
        getParentApi: () => container,
        key: `${type}_${id}`,
        panelProps: panelProps,
        onApiAvailable: api => container.registerChildApi(api)
      });
    }
    // render legacy embeddable
    return /*#__PURE__*/_react2.default.createElement(_public.EmbeddablePanel, (0, _extends2.default)({
      key: type,
      index: index,
      embeddable: () => container.untilEmbeddableLoaded(id)
    }, panelProps));
  }, [id, container, type, index, useMargins]);
  return /*#__PURE__*/_react2.default.createElement("div", (0, _extends2.default)({
    css: focusStyles,
    className: [classes, className].join(' '),
    "data-test-subj": "dashboardPanel",
    id: `panel-${id}`,
    ref: ref
  }, rest), isRenderable ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, renderedEmbeddable, children) : /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingChart, {
    size: "l",
    mono: true
  })));
});
const ObservedItem = exports.ObservedItem = /*#__PURE__*/_react2.default.forwardRef((props, panelRef) => {
  const [intersection, updateIntersection] = (0, _react2.useState)();
  const [isRenderable, setIsRenderable] = (0, _react2.useState)(false);
  const observerRef = (0, _react2.useRef)(new window.IntersectionObserver(([value]) => updateIntersection(value), {
    root: panelRef.current
  }));
  (0, _react2.useEffect)(() => {
    const {
      current: currentObserver
    } = observerRef;
    currentObserver.disconnect();
    const {
      current
    } = panelRef;
    if (current) {
      currentObserver.observe(current);
    }
    return () => currentObserver.disconnect();
  }, [panelRef]);
  (0, _react2.useEffect)(() => {
    if (intersection !== null && intersection !== void 0 && intersection.isIntersecting && !isRenderable) {
      setIsRenderable(true);
    }
  }, [intersection, isRenderable]);
  return /*#__PURE__*/_react2.default.createElement(Item, (0, _extends2.default)({
    ref: panelRef,
    isRenderable: isRenderable
  }, props));
});

// ReactGridLayout passes ref to children. Functional component children require forwardRef to avoid react warning
// https://github.com/react-grid-layout/react-grid-layout#custom-child-components-and-draggable-handles
const DashboardGridItem = exports.DashboardGridItem = /*#__PURE__*/_react2.default.forwardRef((props, ref) => {
  const {
    settings: {
      isProjectEnabledInLabs
    }
  } = _plugin_services.pluginServices.getServices();
  const container = (0, _dashboard_container.useDashboardContainer)();
  const focusedPanelId = container.select(state => state.componentState.focusedPanelId);
  const dashboard = (0, _dashboard_container.useDashboardContainer)();
  const isPrintMode = dashboard.select(state => state.explicitInput.viewMode) === _public.ViewMode.PRINT;
  const isEnabled = !isPrintMode && isProjectEnabledInLabs('labs:dashboard:deferBelowFold') && (!focusedPanelId || focusedPanelId === props.id);
  return isEnabled ? /*#__PURE__*/_react2.default.createElement(ObservedItem, (0, _extends2.default)({
    ref: ref
  }, props)) : /*#__PURE__*/_react2.default.createElement(Item, (0, _extends2.default)({
    ref: ref
  }, props));
});