"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardGrid = void 0;
require("react-resizable/css/styles.css");
require("react-grid-layout/css/styles.css");
var _lodash = require("lodash");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _reactGridLayout = require("react-grid-layout");
var _public = require("@kbn/embeddable-plugin/public");
var _dashboard_grid_item = require("./dashboard_grid_item");
var _use_dashboard_grid_settings = require("./use_dashboard_grid_settings");
var _dashboard_container = require("../../embeddable/dashboard_container");
var _dashboard_diffing_utils = require("../../state/diffing/dashboard_diffing_utils");
var _dashboard_constants = require("../../../dashboard_constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardGrid = ({
  viewportWidth
}) => {
  const dashboard = (0, _dashboard_container.useDashboardContainer)();
  const panels = dashboard.select(state => state.explicitInput.panels);
  const viewMode = dashboard.select(state => state.explicitInput.viewMode);
  const useMargins = dashboard.select(state => state.explicitInput.useMargins);
  const expandedPanelId = dashboard.select(state => state.componentState.expandedPanelId);
  const focusedPanelId = dashboard.select(state => state.componentState.focusedPanelId);
  const animatePanelTransforms = dashboard.select(state => state.componentState.animatePanelTransforms);

  /**
   *  Track panel maximized state delayed by one tick and use it to prevent
   * panel sliding animations on maximize and minimize.
   */
  const [delayedIsPanelExpanded, setDelayedIsPanelMaximized] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (expandedPanelId) {
      setDelayedIsPanelMaximized(true);
    } else {
      setTimeout(() => setDelayedIsPanelMaximized(false), 0);
    }
  }, [expandedPanelId]);
  const panelsInOrder = (0, _react.useMemo)(() => {
    return Object.keys(panels).sort((embeddableIdA, embeddableIdB) => {
      const panelA = panels[embeddableIdA];
      const panelB = panels[embeddableIdB];

      // need to manually sort the panels by position because we want the panels to be collapsed from the left to the
      // right when switching to the single column layout, but RGL sorts by ID which can cause unexpected behaviour between
      // by-reference and by-value panels + we want the HTML order to align with this in the multi-panel view
      if (panelA.gridData.y === panelB.gridData.y) {
        return panelA.gridData.x - panelB.gridData.x;
      } else {
        return panelA.gridData.y - panelB.gridData.y;
      }
    });
  }, [panels]);
  const panelComponents = (0, _react.useMemo)(() => {
    return panelsInOrder.map((embeddableId, index) => {
      const type = panels[embeddableId].type;
      return /*#__PURE__*/_react.default.createElement(_dashboard_grid_item.DashboardGridItem, {
        "data-grid": panels[embeddableId].gridData,
        key: embeddableId,
        id: embeddableId,
        index: index + 1,
        type: type,
        expandedPanelId: expandedPanelId,
        focusedPanelId: focusedPanelId
      });
    });
  }, [expandedPanelId, panels, panelsInOrder, focusedPanelId]);
  const onLayoutChange = (0, _react.useCallback)(newLayout => {
    if (viewMode !== _public.ViewMode.EDIT) return;
    const updatedPanels = newLayout.reduce((updatedPanelsAcc, panelLayout) => {
      updatedPanelsAcc[panelLayout.i] = {
        ...panels[panelLayout.i],
        gridData: (0, _lodash.pick)(panelLayout, ['x', 'y', 'w', 'h', 'i'])
      };
      return updatedPanelsAcc;
    }, {});
    if (!(0, _dashboard_diffing_utils.getPanelLayoutsAreEqual)(panels, updatedPanels)) {
      dashboard.dispatch.setPanels(updatedPanels);
    }
  }, [dashboard, panels, viewMode]);
  const classes = (0, _classnames.default)({
    'dshLayout-withoutMargins': !useMargins,
    'dshLayout--viewing': viewMode === _public.ViewMode.VIEW,
    'dshLayout--editing': viewMode !== _public.ViewMode.VIEW,
    'dshLayout--noAnimation': !animatePanelTransforms || delayedIsPanelExpanded,
    'dshLayout-isMaximizedPanel': expandedPanelId !== undefined
  });
  const {
    layouts,
    breakpoints,
    columns
  } = (0, _use_dashboard_grid_settings.useDashboardGridSettings)(panelsInOrder);

  // in print mode, dashboard layout is not controlled by React Grid Layout
  if (viewMode === _public.ViewMode.PRINT) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, panelComponents);
  }
  return /*#__PURE__*/_react.default.createElement(_reactGridLayout.Responsive, {
    cols: columns,
    layouts: layouts,
    className: classes,
    width: viewportWidth,
    breakpoints: breakpoints,
    onLayoutChange: onLayoutChange,
    isResizable: !expandedPanelId && !focusedPanelId,
    isDraggable: !expandedPanelId && !focusedPanelId,
    rowHeight: _dashboard_constants.DASHBOARD_GRID_HEIGHT,
    margin: useMargins ? [_dashboard_constants.DASHBOARD_MARGIN_SIZE, _dashboard_constants.DASHBOARD_MARGIN_SIZE] : [0, 0],
    draggableHandle: '.embPanel--dragHandle'
  }, panelComponents);
};
exports.DashboardGrid = DashboardGrid;