"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeGroupedItemsProvider = exports.getEmbeddableFactoryMenuItemProvider = exports.EditorMenu = void 0;
require("./editor_menu.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _public2 = require("@kbn/visualizations-plugin/public");
var _public3 = require("@kbn/embeddable-plugin/public");
var _plugin_services = require("../../services/plugin_services");
var _add_panel_action_menu_items = require("./add_panel_action_menu_items");
var _open_dashboard_panel_selection_flyout = require("./open_dashboard_panel_selection_flyout");
var _dashboard_app = require("../dashboard_app");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getEmbeddableFactoryMenuItemProvider = (api, closePopover) => factory => {
  var _factory$getDescripti, _factory$order;
  const icon = factory !== null && factory !== void 0 && factory.getIconType ? factory.getIconType() : 'empty';
  return {
    id: factory.type,
    name: factory.getDisplayName(),
    icon,
    description: (_factory$getDescripti = factory.getDescription) === null || _factory$getDescripti === void 0 ? void 0 : _factory$getDescripti.call(factory),
    onClick: async () => {
      closePopover();
      api.addNewPanel({
        panelType: factory.type
      }, true);
    },
    'data-test-subj': `createNew-${factory.type}`,
    order: (_factory$order = factory.order) !== null && _factory$order !== void 0 ? _factory$order : 0
  };
};
exports.getEmbeddableFactoryMenuItemProvider = getEmbeddableFactoryMenuItemProvider;
const sortGroupPanelsByOrder = panelGroups => {
  return panelGroups.sort(
  // larger number sorted to the top
  (panelGroupA, panelGroupB) => panelGroupB.order - panelGroupA.order);
};
const mergeGroupedItemsProvider = getEmbeddableFactoryMenuItem => (factoryGroupMap, groupedAddPanelAction) => {
  const panelGroups = [];
  new Set(Object.keys(factoryGroupMap).concat(Object.keys(groupedAddPanelAction))).forEach(groupId => {
    const dataTestSubj = `dashboardEditorMenu-${groupId}Group`;
    const factoryGroup = factoryGroupMap[groupId];
    const addPanelGroup = groupedAddPanelAction[groupId];
    if (factoryGroup && addPanelGroup) {
      var _addPanelGroup$items;
      panelGroups.push({
        id: factoryGroup.id,
        title: factoryGroup.appName,
        'data-test-subj': dataTestSubj,
        order: factoryGroup.order,
        items: [...factoryGroup.factories.map(getEmbeddableFactoryMenuItem), ...((_addPanelGroup$items = addPanelGroup === null || addPanelGroup === void 0 ? void 0 : addPanelGroup.items) !== null && _addPanelGroup$items !== void 0 ? _addPanelGroup$items : [])]
      });
    } else if (factoryGroup) {
      panelGroups.push({
        id: factoryGroup.id,
        title: factoryGroup.appName,
        'data-test-subj': dataTestSubj,
        order: factoryGroup.order,
        items: factoryGroup.factories.map(getEmbeddableFactoryMenuItem)
      });
    } else if (addPanelGroup) {
      panelGroups.push(addPanelGroup);
    }
  });
  return panelGroups;
};
exports.mergeGroupedItemsProvider = mergeGroupedItemsProvider;
const EditorMenu = ({
  createNewVisType,
  isDisabled,
  api
}) => {
  const isMounted = (0, _react.useRef)(false);
  const flyoutRef = (0, _react.useRef)();
  const dashboard = (0, _dashboard_app.useDashboardAPI)();
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      var _flyoutRef$current;
      isMounted.current = false;
      (_flyoutRef$current = flyoutRef.current) === null || _flyoutRef$current === void 0 ? void 0 : _flyoutRef$current.close();
    };
  }, []);
  const {
    embeddable,
    visualizations: {
      getAliases: getVisTypeAliases,
      getByGroup: getVisTypesByGroup
    },
    uiActions
  } = _plugin_services.pluginServices.getServices();
  const [unwrappedEmbeddableFactories, setUnwrappedEmbeddableFactories] = (0, _react.useState)([]);
  const [addPanelActions, setAddPanelActions] = (0, _react.useState)(undefined);
  const embeddableFactories = (0, _react.useMemo)(() => Array.from(embeddable.getEmbeddableFactories()), [embeddable]);
  (0, _react.useEffect)(() => {
    Promise.all(embeddableFactories.map(async factory => ({
      factory,
      isEditable: await factory.isEditable()
    }))).then(factories => {
      setUnwrappedEmbeddableFactories(factories);
    });
  }, [embeddableFactories]);
  const getSortedVisTypesByGroup = group => getVisTypesByGroup(group).sort((a, b) => {
    const labelA = 'titleInWizard' in a ? a.titleInWizard || a.title : a.title;
    const labelB = 'titleInWizard' in b ? b.titleInWizard || a.title : a.title;
    if (labelA < labelB) {
      return -1;
    }
    if (labelA > labelB) {
      return 1;
    }
    return 0;
  }).filter(({
    disableCreate
  }) => !disableCreate);
  const promotedVisTypes = getSortedVisTypesByGroup(_public2.VisGroups.PROMOTED);
  const toolVisTypes = getSortedVisTypesByGroup(_public2.VisGroups.TOOLS);
  const legacyVisTypes = getSortedVisTypesByGroup(_public2.VisGroups.LEGACY);
  const visTypeAliases = getVisTypeAliases().sort(({
    promotion: a = false
  }, {
    promotion: b = false
  }) => a === b ? 0 : a ? -1 : 1).filter(({
    disableCreate
  }) => !disableCreate);
  const factories = unwrappedEmbeddableFactories.filter(({
    isEditable,
    factory: {
      type,
      canCreateNew,
      isContainerType
    }
  }) => isEditable && !isContainerType && canCreateNew() && type !== 'visualization');
  const factoryGroupMap = {};

  // Retrieve ADD_PANEL_TRIGGER actions
  (0, _react.useEffect)(() => {
    async function loadPanelActions() {
      var _uiActions$getTrigger;
      const registeredActions = await (uiActions === null || uiActions === void 0 ? void 0 : (_uiActions$getTrigger = uiActions.getTriggerCompatibleActions) === null || _uiActions$getTrigger === void 0 ? void 0 : _uiActions$getTrigger.call(uiActions, _public.ADD_PANEL_TRIGGER, {
        embeddable: api
      }));
      if (isMounted.current) {
        setAddPanelActions(registeredActions);
      }
    }
    loadPanelActions();
  }, [uiActions, api]);
  factories.forEach(({
    factory
  }) => {
    const {
      grouping
    } = factory;
    if (grouping) {
      grouping.forEach(group => {
        if (factoryGroupMap[group.id]) {
          factoryGroupMap[group.id].factories.push(factory);
        } else {
          var _group$getIconType, _group$order;
          factoryGroupMap[group.id] = {
            id: group.id,
            appName: group.getDisplayName ? group.getDisplayName({
              embeddable: dashboard
            }) : group.id,
            icon: (_group$getIconType = group.getIconType) === null || _group$getIconType === void 0 ? void 0 : _group$getIconType.call(group, {
              embeddable: dashboard
            }),
            factories: [factory],
            order: (_group$order = group.order) !== null && _group$order !== void 0 ? _group$order : 0
          };
        }
      });
    } else {
      const fallbackGroup = _public3.COMMON_EMBEDDABLE_GROUPING.other;
      if (!factoryGroupMap[fallbackGroup.id]) {
        var _fallbackGroup$getIco, _fallbackGroup$order;
        factoryGroupMap[fallbackGroup.id] = {
          id: fallbackGroup.id,
          appName: fallbackGroup.getDisplayName ? fallbackGroup.getDisplayName({
            embeddable: dashboard
          }) : fallbackGroup.id,
          icon: ((_fallbackGroup$getIco = fallbackGroup.getIconType) === null || _fallbackGroup$getIco === void 0 ? void 0 : _fallbackGroup$getIco.call(fallbackGroup, {
            embeddable: dashboard
          })) || 'empty',
          factories: [],
          order: (_fallbackGroup$order = fallbackGroup.order) !== null && _fallbackGroup$order !== void 0 ? _fallbackGroup$order : 0
        };
      }
      factoryGroupMap[fallbackGroup.id].factories.push(factory);
    }
  });
  const augmentedCreateNewVisType = (visType, cb) => {
    const visClickHandler = createNewVisType(visType);
    return () => {
      visClickHandler();
      cb();
    };
  };
  const getVisTypeMenuItem = (onClickCb, visType) => {
    const {
      name,
      title,
      titleInWizard,
      description,
      icon = 'empty',
      isDeprecated,
      order
    } = visType;
    return {
      id: name,
      name: titleInWizard || title,
      isDeprecated,
      icon,
      onClick: augmentedCreateNewVisType(visType, onClickCb),
      'data-test-subj': `visType-${name}`,
      description,
      order
    };
  };
  const getVisTypeAliasMenuItem = (onClickCb, visTypeAlias) => {
    const {
      name,
      title,
      description,
      icon = 'empty',
      order
    } = visTypeAlias;
    return {
      id: name,
      name: title,
      icon,
      onClick: augmentedCreateNewVisType(visTypeAlias, onClickCb),
      'data-test-subj': `visType-${name}`,
      description,
      order: order !== null && order !== void 0 ? order : 0
    };
  };
  const getEditorMenuPanels = closeFlyout => {
    const getEmbeddableFactoryMenuItem = getEmbeddableFactoryMenuItemProvider(api, closeFlyout);
    const groupedAddPanelAction = (0, _add_panel_action_menu_items.getAddPanelActionMenuItemsGroup)(api, addPanelActions, closeFlyout);
    const initialPanelGroups = mergeGroupedItemsProvider(getEmbeddableFactoryMenuItem)(factoryGroupMap, groupedAddPanelAction);

    // enhance panel groups
    return sortGroupPanelsByOrder(initialPanelGroups).map(panelGroup => {
      switch (panelGroup.id) {
        case 'visualizations':
          {
            var _panelGroup$items;
            return {
              ...panelGroup,
              items: sortGroupPanelsByOrder(((_panelGroup$items = panelGroup.items) !== null && _panelGroup$items !== void 0 ? _panelGroup$items : []).concat(
              // TODO: actually add grouping to vis type alias so we wouldn't randomly display an unintended item
              visTypeAliases.map(getVisTypeAliasMenuItem.bind(null, closeFlyout)), promotedVisTypes.map(getVisTypeMenuItem.bind(null, closeFlyout))))
            };
          }
        case _public3.COMMON_EMBEDDABLE_GROUPING.legacy.id:
          {
            var _panelGroup$items2;
            return {
              ...panelGroup,
              items: sortGroupPanelsByOrder(((_panelGroup$items2 = panelGroup.items) !== null && _panelGroup$items2 !== void 0 ? _panelGroup$items2 : []).concat(legacyVisTypes.map(getVisTypeMenuItem.bind(null, closeFlyout))))
            };
          }
        case _public3.COMMON_EMBEDDABLE_GROUPING.annotation.id:
          {
            var _panelGroup$items3;
            return {
              ...panelGroup,
              items: sortGroupPanelsByOrder(((_panelGroup$items3 = panelGroup.items) !== null && _panelGroup$items3 !== void 0 ? _panelGroup$items3 : []).concat(toolVisTypes.map(getVisTypeMenuItem.bind(null, closeFlyout))))
            };
          }
        default:
          {
            return {
              ...panelGroup,
              items: sortGroupPanelsByOrder(panelGroup.items)
            };
          }
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
    "data-test-subj": "dashboardEditorMenuButton",
    isDisabled: isDisabled,
    iconType: "plusInCircle",
    label: _i18n.i18n.translate('dashboard.solutionToolbar.editorMenuButtonLabel', {
      defaultMessage: 'Add panel'
    }),
    onClick: () => {
      flyoutRef.current = (0, _open_dashboard_panel_selection_flyout.openDashboardPanelSelectionFlyout)({
        getPanels: getEditorMenuPanels
      });
    },
    size: "s"
  });
};
exports.EditorMenu = EditorMenu;