"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddTimeSliderControlButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/controls-plugin/public");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _dashboard_app = require("../../dashboard_app");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const AddTimeSliderControlButton = ({
  closePopover,
  controlGroup,
  ...rest
}) => {
  const [hasTimeSliderControl, setHasTimeSliderControl] = (0, _react.useState)(false);
  const dashboard = (0, _dashboard_app.useDashboardAPI)();
  (0, _react.useEffect)(() => {
    const subscription = controlGroup.getInput$().subscribe(() => {
      const childIds = controlGroup.getChildIds();
      const nextHasTimeSliderControl = childIds.some(id => {
        const child = controlGroup.getChild(id);
        return child.type === _public.TIME_SLIDER_CONTROL;
      });
      if (nextHasTimeSliderControl !== hasTimeSliderControl) {
        setHasTimeSliderControl(nextHasTimeSliderControl);
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [controlGroup, hasTimeSliderControl, setHasTimeSliderControl]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({}, rest, {
    icon: "timeslider",
    onClick: async () => {
      await controlGroup.addTimeSliderControl();
      dashboard.scrollToTop();
      closePopover();
    },
    "data-test-subj": "controls-create-timeslider-button",
    disabled: hasTimeSliderControl,
    toolTipContent: hasTimeSliderControl ? (0, _dashboard_app_strings.getOnlyOneTimeSliderControlMsg)() : null
  }), (0, _dashboard_app_strings.getAddTimeSliderControlButtonTitle)());
};
exports.AddTimeSliderControlButton = AddTimeSliderControlButton;