"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanEmptyKeys = exports.DashboardAppLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _dashboard_constants = require("../../dashboard_constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Useful for ensuring that we don't pass any non-serializable values to history.push (for example, functions).
 */
const getSerializableRecord = (0, _lodash.flow)(JSON.stringify, JSON.parse);
const cleanEmptyKeys = stateObj => {
  Object.keys(stateObj).forEach(key => {
    if (stateObj[key] === undefined) {
      delete stateObj[key];
    }
  });
  return stateObj;
};
exports.cleanEmptyKeys = cleanEmptyKeys;
class DashboardAppLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", _deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const {
        filters,
        useHash: paramsUseHash,
        preserveSavedFilters,
        dashboardId,
        ...restParams
      } = params;
      const useHash = paramsUseHash !== null && paramsUseHash !== void 0 ? paramsUseHash : this.deps.useHashedUrl;
      const hash = dashboardId ? `view/${dashboardId}` : `create`;
      const getSavedFiltersFromDestinationDashboardIfNeeded = async () => {
        if (preserveSavedFilters === false) return [];
        if (!params.dashboardId) return [];
        try {
          return await this.deps.getDashboardFilterFields(params.dashboardId);
        } catch (e) {
          // In case dashboard is missing, build the url without those filters.
          // The Dashboard app will handle redirect to landing page with a toast message.
          return [];
        }
      };
      const state = restParams;

      // leave filters `undefined` if no filters was applied
      // in this case dashboard will restore saved filters on its own
      state.filters = params.filters && [...(await getSavedFiltersFromDestinationDashboardIfNeeded()), ...params.filters];
      const {
        isFilterPinned
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      let path = `#/${hash}`;
      path = (0, _public.setStateToKbnUrl)('_g', cleanEmptyKeys({
        time: params.timeRange,
        filters: filters === null || filters === void 0 ? void 0 : filters.filter(f => isFilterPinned(f)),
        refreshInterval: params.refreshInterval
      }), {
        useHash
      }, path);
      if (params.searchSessionId) {
        path = `${path}&${_dashboard_constants.SEARCH_SESSION_ID}=${params.searchSessionId}`;
      }
      return {
        app: _dashboard_constants.DASHBOARD_APP_ID,
        path,
        state: getSerializableRecord(cleanEmptyKeys(state))
      };
    });
    this.deps = deps;
  }
}
exports.DashboardAppLocatorDefinition = DashboardAppLocatorDefinition;