"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardNoMatch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _dashboard_constants = require("../../dashboard_constants");
var _plugin_services = require("../../services/plugin_services");
var _dashboard_mount_context = require("../hooks/dashboard_mount_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let bannerId;
const DashboardNoMatch = ({
  history
}) => {
  const {
    restorePreviousUrl
  } = (0, _dashboard_mount_context.useDashboardMountContext)();
  const {
    analytics,
    settings: {
      i18n: i18nStart,
      theme
    },
    overlays: {
      banners
    },
    urlForwarding: {
      navigateToLegacyKibanaUrl
    }
  } = _plugin_services.pluginServices.getServices();
  (0, _react.useEffect)(() => {
    restorePreviousUrl();
    const {
      navigated
    } = navigateToLegacyKibanaUrl(history.location.pathname + history.location.search);
    if (!navigated) {
      const bannerMessage = _i18n.i18n.translate('dashboard.noMatchRoute.bannerTitleText', {
        defaultMessage: 'Page not found'
      });
      bannerId = banners.replace(bannerId, (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        iconType: "iInCircle",
        title: bannerMessage
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.noMatchRoute.bannerText",
        defaultMessage: "Dashboard application doesn't recognize this route: {route}.",
        values: {
          route: history.location.pathname
        }
      }))), {
        analytics,
        i18n: i18nStart,
        theme
      }));

      // hide the message after the user has had a chance to acknowledge it -- so it doesn't permanently stick around
      setTimeout(() => {
        if (bannerId) {
          banners.remove(bannerId);
        }
      }, 15000);
      history.replace(_dashboard_constants.LANDING_PAGE_PATH);
    }
  }, [restorePreviousUrl, navigateToLegacyKibanaUrl, banners, analytics, i18nStart, theme, history]);
  return null;
};
exports.DashboardNoMatch = DashboardNoMatch;