"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardPageTitle = exports.getDashboardBreadcrumb = exports.getCreateVisualizationButtonTitle = exports.getControlButtonTitle = exports.getAddTimeSliderControlButtonTitle = exports.getAddControlButtonTitle = exports.dashboardReadonlyBadge = exports.dashboardManagedBadge = void 0;
exports.getDashboardTitle = getDashboardTitle;
exports.unsavedChangesBadgeStrings = exports.topNavStrings = exports.shareModalStrings = exports.leaveConfirmStrings = exports.getQuickCreateButtonGroupLegend = exports.getPanelTooOldErrorString = exports.getPanelAddedSuccessString = exports.getOnlyOneTimeSliderControlMsg = exports.getNewDashboardTitle = exports.getEditControlGroupButtonTitle = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDashboardPageTitle = () => _i18n.i18n.translate('dashboard.dashboardPageTitle', {
  defaultMessage: 'Dashboards'
});
exports.getDashboardPageTitle = getDashboardPageTitle;
const dashboardReadonlyBadge = exports.dashboardReadonlyBadge = {
  getText: () => _i18n.i18n.translate('dashboard.badge.readOnly.text', {
    defaultMessage: 'Read only'
  }),
  getTooltip: () => _i18n.i18n.translate('dashboard.badge.readOnly.tooltip', {
    defaultMessage: 'Unable to save dashboards'
  })
};
const dashboardManagedBadge = exports.dashboardManagedBadge = {
  getTooltip: () => _i18n.i18n.translate('dashboard.badge.managed.tooltip', {
    defaultMessage: 'Elastic manages this dashboard. Clone it to make changes.'
  })
};

/**
 * @param title {string} the current title of the dashboard
 * @param viewMode {DashboardViewMode} the current mode. If in editing state, prepends 'Editing ' to the title.
 * @returns {string} A title to display to the user based on the above parameters.
 */
function getDashboardTitle(title, viewMode, isNew) {
  const isEditMode = viewMode === _public.ViewMode.EDIT;
  const dashboardTitle = isNew ? getNewDashboardTitle() : title;
  return isEditMode ? _i18n.i18n.translate('dashboard.strings.dashboardEditTitle', {
    defaultMessage: 'Editing {title}',
    values: {
      title: dashboardTitle
    }
  }) : dashboardTitle;
}
const unsavedChangesBadgeStrings = exports.unsavedChangesBadgeStrings = {
  getUnsavedChangedBadgeText: () => _i18n.i18n.translate('dashboard.unsavedChangesBadge', {
    defaultMessage: 'Unsaved changes'
  }),
  getUnsavedChangedBadgeToolTipContent: () => _i18n.i18n.translate('dashboard.unsavedChangesBadgeToolTipContent', {
    defaultMessage: ' You have unsaved changes in this dashboard. To remove this label, save the dashboard.'
  }),
  getHasRunMigrationsText: () => _i18n.i18n.translate('dashboard.hasRunMigrationsBadge', {
    defaultMessage: 'Save recommended'
  }),
  getHasRunMigrationsToolTipContent: () => _i18n.i18n.translate('dashboard.hasRunMigrationsBadgeToolTipContent', {
    defaultMessage: 'One or more panels on this dashboard have been updated to a new version. Save the dashboard so it loads faster next time.'
  })
};
const leaveConfirmStrings = exports.leaveConfirmStrings = {
  getLeaveTitle: () => _i18n.i18n.translate('dashboard.appLeaveConfirmModal.unsavedChangesTitle', {
    defaultMessage: 'Unsaved changes'
  }),
  getLeaveSubtitle: () => _i18n.i18n.translate('dashboard.appLeaveConfirmModal.unsavedChangesSubtitle', {
    defaultMessage: 'Leave Dashboard with unsaved work?'
  }),
  getLeaveCancelButtonText: () => _i18n.i18n.translate('dashboard.appLeaveConfirmModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })
};
const getCreateVisualizationButtonTitle = () => _i18n.i18n.translate('dashboard.solutionToolbar.addPanelButtonLabel', {
  defaultMessage: 'Create visualization'
});
exports.getCreateVisualizationButtonTitle = getCreateVisualizationButtonTitle;
const getQuickCreateButtonGroupLegend = () => _i18n.i18n.translate('dashboard.solutionToolbar.quickCreateButtonGroupLegend', {
  defaultMessage: 'Shortcuts to popular visualization types'
});
exports.getQuickCreateButtonGroupLegend = getQuickCreateButtonGroupLegend;
const getNewDashboardTitle = () => _i18n.i18n.translate('dashboard.savedDashboard.newDashboardTitle', {
  defaultMessage: 'New Dashboard'
});
exports.getNewDashboardTitle = getNewDashboardTitle;
const getPanelAddedSuccessString = savedObjectName => savedObjectName ? _i18n.i18n.translate('dashboard.addPanel.newEmbeddableAddedSuccessMessageTitle', {
  defaultMessage: '{savedObjectName} was added',
  values: {
    savedObjectName
  }
}) : _i18n.i18n.translate('dashboard.addPanel.newEmbeddableWithNoTitleAddedSuccessMessageTitle', {
  defaultMessage: 'A panel was added'
});
exports.getPanelAddedSuccessString = getPanelAddedSuccessString;
const getPanelTooOldErrorString = () => _i18n.i18n.translate('dashboard.loadURLError.PanelTooOld', {
  defaultMessage: 'Cannot load panels from a URL created in a version older than 7.3'
});

/*
  Share Modal
*/
exports.getPanelTooOldErrorString = getPanelTooOldErrorString;
const shareModalStrings = exports.shareModalStrings = {
  getTopMenuCheckbox: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.topMenu', {
    defaultMessage: 'Top menu'
  }),
  getQueryCheckbox: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.query', {
    defaultMessage: 'Query'
  }),
  getTimeFilterCheckbox: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.timeFilter', {
    defaultMessage: 'Time filter'
  }),
  getFilterBarCheckbox: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.filterBar', {
    defaultMessage: 'Filter bar'
  }),
  getCheckboxLegend: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.include', {
    defaultMessage: 'Include'
  }),
  getSnapshotShareWarning: () => _i18n.i18n.translate('dashboard.snapshotShare.longUrlWarning', {
    defaultMessage: 'One or more panels on this dashboard have changed. Before you generate a snapshot, save the dashboard.'
  })
};

/*
  Dashboard Top Nav
*/
const getDashboardBreadcrumb = () => _i18n.i18n.translate('dashboard.dashboardAppBreadcrumbsTitle', {
  defaultMessage: 'Dashboards'
});
exports.getDashboardBreadcrumb = getDashboardBreadcrumb;
const topNavStrings = exports.topNavStrings = {
  fullScreen: {
    label: _i18n.i18n.translate('dashboard.topNave.fullScreenButtonAriaLabel', {
      defaultMessage: 'full screen'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.fullScreenConfigDescription', {
      defaultMessage: 'Full Screen Mode'
    })
  },
  labs: {
    label: _i18n.i18n.translate('dashboard.topNav.labsButtonAriaLabel', {
      defaultMessage: 'labs'
    }),
    description: _i18n.i18n.translate('dashboard.topNav.labsConfigDescription', {
      defaultMessage: 'Labs'
    })
  },
  edit: {
    label: _i18n.i18n.translate('dashboard.topNave.editButtonAriaLabel', {
      defaultMessage: 'edit'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.editConfigDescription', {
      defaultMessage: 'Switch to edit mode'
    })
  },
  quickSave: {
    label: _i18n.i18n.translate('dashboard.topNave.saveButtonAriaLabel', {
      defaultMessage: 'save'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.saveConfigDescription', {
      defaultMessage: 'Quick save your dashboard without any prompts'
    })
  },
  editModeInteractiveSave: {
    label: _i18n.i18n.translate('dashboard.topNave.editModeInteractiveSaveButtonAriaLabel', {
      defaultMessage: 'save as'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.editModeInteractiveSaveConfigDescription', {
      defaultMessage: 'Save as a new dashboard'
    })
  },
  resetChanges: {
    label: _i18n.i18n.translate('dashboard.topNave.resetChangesButtonAriaLabel', {
      defaultMessage: 'Reset'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.resetChangesConfigDescription', {
      defaultMessage: 'Reset changes to dashboard'
    })
  },
  switchToViewMode: {
    label: _i18n.i18n.translate('dashboard.topNave.cancelButtonAriaLabel', {
      defaultMessage: 'Switch to view mode'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.viewConfigDescription', {
      defaultMessage: 'Switch to view-only mode'
    })
  },
  share: {
    label: _i18n.i18n.translate('dashboard.topNave.shareButtonAriaLabel', {
      defaultMessage: 'share'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.shareConfigDescription', {
      defaultMessage: 'Share Dashboard'
    })
  },
  settings: {
    label: _i18n.i18n.translate('dashboard.topNave.settingsButtonAriaLabel', {
      defaultMessage: 'settings'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.settingsConfigDescription', {
      defaultMessage: 'Open dashboard settings'
    })
  },
  viewModeInteractiveSave: {
    label: _i18n.i18n.translate('dashboard.topNave.viewModeInteractiveSaveButtonAriaLabel', {
      defaultMessage: 'duplicate'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.viewModeInteractiveSaveConfigDescription', {
      defaultMessage: 'Create a copy of your dashboard'
    })
  }
};
const getControlButtonTitle = () => _i18n.i18n.translate('dashboard.editingToolbar.controlsButtonTitle', {
  defaultMessage: 'Controls'
});
exports.getControlButtonTitle = getControlButtonTitle;
const getAddControlButtonTitle = () => _i18n.i18n.translate('dashboard.editingToolbar.addControlButtonTitle', {
  defaultMessage: 'Add control'
});
exports.getAddControlButtonTitle = getAddControlButtonTitle;
const getEditControlGroupButtonTitle = () => _i18n.i18n.translate('dashboard.editingToolbar.editControlGroupButtonTitle', {
  defaultMessage: 'Settings'
});
exports.getEditControlGroupButtonTitle = getEditControlGroupButtonTitle;
const getOnlyOneTimeSliderControlMsg = () => _i18n.i18n.translate('dashboard.editingToolbar.onlyOneTimeSliderControlMsg', {
  defaultMessage: 'Control group already contains time slider control.'
});
exports.getOnlyOneTimeSliderControlMsg = getOnlyOneTimeSliderControlMsg;
const getAddTimeSliderControlButtonTitle = () => _i18n.i18n.translate('dashboard.editingToolbar.addTimeSliderControlButtonTitle', {
  defaultMessage: 'Add time slider control'
});
exports.getAddTimeSliderControlButtonTitle = getAddTimeSliderControlButtonTitle;