"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandPanelAction = exports.ACTION_EXPAND_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_EXPAND_PANEL = exports.ACTION_EXPAND_PANEL = 'togglePanel';
const isApiCompatible = api => Boolean((0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationContainers.apiCanExpandPanels)(api.parentApi));
class ExpandPanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_EXPAND_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_EXPAND_PANEL);
    (0, _defineProperty2.default)(this, "order", 7);
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return embeddable.parentApi.expandedPanelId.value ? _dashboard_actions_strings.dashboardExpandPanelActionStrings.getMinimizeTitle() : _dashboard_actions_strings.dashboardExpandPanelActionStrings.getMaximizeTitle();
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return embeddable.parentApi.expandedPanelId.value ? 'minimize' : 'expand';
  }
  async isCompatible({
    embeddable
  }) {
    return isApiCompatible(embeddable);
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    embeddable.parentApi.expandPanel(embeddable.uuid);
  }
}
exports.ExpandPanelAction = ExpandPanelAction;