"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToDashboardModal = CopyToDashboardModal;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/presentation-util-plugin/public");
var _dashboard_constants = require("../dashboard_constants");
var _plugin_services = require("../services/plugin_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardPicker = (0, _public2.withSuspense)(_public2.LazyDashboardPicker);
function CopyToDashboardModal({
  api,
  closeModal
}) {
  const {
    embeddable: {
      getStateTransfer
    },
    dashboardCapabilities: {
      createNew: canCreateNew,
      showWriteControls: canEditExisting
    }
  } = _plugin_services.pluginServices.getServices();
  const stateTransfer = getStateTransfer();
  const [dashboardOption, setDashboardOption] = (0, _react.useState)('existing');
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)(null);
  const dashboardId = api.parentApi.savedObjectId.value;
  const onSubmit = (0, _react.useCallback)(async () => {
    const dashboard = api.parentApi;
    const panelToCopy = await dashboard.getDashboardPanelFromId(api.uuid);
    if (!panelToCopy) {
      throw new _public.PanelNotFoundError();
    }
    const state = {
      type: panelToCopy.type,
      input: {
        ...(0, _lodash.omit)(panelToCopy.explicitInput, 'id')
      },
      size: {
        width: panelToCopy.gridData.w,
        height: panelToCopy.gridData.h
      },
      references: panelToCopy.references
    };
    const path = dashboardOption === 'existing' && selectedDashboard ? `#${(0, _dashboard_constants.createDashboardEditUrl)(selectedDashboard.id, true)}` : `#${_dashboard_constants.CREATE_NEW_DASHBOARD_URL}`;
    closeModal();
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [api, dashboardOption, selectedDashboard, closeModal, stateTransfer]);
  const titleId = 'copyToDashboardTitle';
  const descriptionId = 'copyToDashboardDescription';
  return /*#__PURE__*/_react.default.createElement("div", {
    role: "dialog",
    "aria-modal": "true",
    "aria-labelledby": titleId,
    "aria-describedby": descriptionId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: titleId,
    component: "h2"
  }, _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getDisplayName())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "add-to-dashboard-options"
  }, canEditExisting && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === 'existing',
    "data-test-subj": "add-to-existing-dashboard-option",
    id: "existing-dashboard-option",
    name: "dashboard-option",
    label: _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getExistingDashboardOption(),
    onChange: () => setDashboardOption('existing')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(DashboardPicker, {
    isDisabled: dashboardOption !== 'existing',
    idsToOmit: dashboardId ? [dashboardId] : undefined,
    onChange: dashboard => {
      setSelectedDashboard(dashboard);
      setDashboardOption('existing');
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), canCreateNew && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === 'new',
    "data-test-subj": "add-to-new-dashboard-option",
    id: "new-dashboard-option",
    name: "dashboard-option",
    disabled: !dashboardId,
    label: _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getNewDashboardOption(),
    onChange: () => setDashboardOption('new')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelCopyToButton",
    onClick: () => closeModal()
  }, _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getCancelButtonName()), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "confirmCopyToButton",
    onClick: onSubmit,
    disabled: dashboardOption === 'existing' && !selectedDashboard
  }, _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getAcceptButtonName())));
}