"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToLibraryAction = exports.ACTION_ADD_TO_LIBRARY = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/saved-objects-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _plugin_services = require("../services/plugin_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_ADD_TO_LIBRARY = exports.ACTION_ADD_TO_LIBRARY = 'saveToLibrary';
const isApiCompatible = api => {
  var _api$parentApi;
  return Boolean((0, _presentationPublishing.apiCanAccessViewMode)(api) && ((0, _presentationPublishing.apiHasLibraryTransforms)(api) || (0, _presentationPublishing.apiHasInPlaceLibraryTransforms)(api)) && (0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && typeof ((_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.replacePanel) === 'function');
};
class AddToLibraryAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_ADD_TO_LIBRARY);
    (0, _defineProperty2.default)(this, "id", ACTION_ADD_TO_LIBRARY);
    (0, _defineProperty2.default)(this, "order", 8);
    (0, _defineProperty2.default)(this, "toastsService", void 0);
    ({
      notifications: {
        toasts: this.toastsService
      }
    } = _plugin_services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    return 'folderCheck';
  }
  async isCompatible({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) return false;
    return (0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit' && (await this.canLinkToLibrary(embeddable));
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    const title = (0, _presentationPublishing.getPanelTitle)(embeddable);
    try {
      const byRefState = await new Promise((resolve, reject) => {
        const onSave = async props => {
          await embeddable.checkForDuplicateTitle(props.newTitle, props.isTitleDuplicateConfirmed, props.onTitleDuplicate);
          try {
            const libraryId = await embeddable.saveToLibrary(props.newTitle);
            if ((0, _presentationPublishing.apiHasLibraryTransforms)(embeddable)) {
              resolve({
                ...embeddable.getByReferenceState(libraryId),
                title: props.newTitle
              });
            }
            resolve(undefined);
            return {
              id: libraryId
            };
          } catch (error) {
            reject(error);
            return {
              error
            };
          }
        };
        (0, _public.showSaveModal)( /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
          onSave: onSave,
          onClose: () => {},
          title: title !== null && title !== void 0 ? title : '',
          showCopyOnSave: false,
          objectType: typeof embeddable.getTypeDisplayName === 'function' ? embeddable.getTypeDisplayName() : embeddable.type,
          showDescription: false
        }));
      });
      /**
       * If byRefState is defined, this embeddable type must be re-initialized with the
       * newly provided state.
       */
      if (byRefState) {
        await embeddable.parentApi.replacePanel(embeddable.uuid, {
          panelType: embeddable.type,
          initialState: byRefState
        });
      }
      this.toastsService.addSuccess({
        title: _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getSuccessMessage(title ? `'${title}'` : ''),
        'data-test-subj': 'addPanelToLibrarySuccess'
      });
    } catch (e) {
      this.toastsService.addDanger({
        title: _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getErrorMessage(title),
        'data-test-subj': 'addPanelToLibraryError'
      });
    }
  }
  async canLinkToLibrary(api) {
    if ((0, _presentationPublishing.apiHasLibraryTransforms)(api)) {
      var _api$canLinkToLibrary;
      return (_api$canLinkToLibrary = api.canLinkToLibrary) === null || _api$canLinkToLibrary === void 0 ? void 0 : _api$canLinkToLibrary.call(api);
    } else if ((0, _presentationPublishing.apiHasInPlaceLibraryTransforms)(api)) {
      const canLink = api.canLinkToLibrary ? await api.canLinkToLibrary() : true;
      return api.libraryId$.value === undefined && canLink;
    }
    throw new _public2.IncompatibleActionError();
  }
}
exports.AddToLibraryAction = AddToLibraryAction;