"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchJavaClientReadme = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _java = _interopRequireDefault(require("../../../assets/language_clients/java.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// eslint-disable-next-line @kbn/eslint/module_migration

const CenterColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 740px;
`;
const FixedHeader = _styledComponents.default.div`
  width: 100%;
  height: 196px;
  border-bottom: 1px solid ${_uiTheme.euiThemeVars.euiColorLightShade};
`;
const IconPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  padding: ${props => props.theme.eui.euiSizeXL};
  width: ${props => parseFloat(props.theme.eui.euiSize) * 6 + parseFloat(props.theme.eui.euiSizeXL) * 2}px;
  svg,
  img {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    width: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
  }
  .euiFlexItem {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    justify-content: center;
  }
`;
const TopFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  max-width: 1150px;
  margin-left: auto;
  margin-right: auto;
  padding: calc(${_uiTheme.euiThemeVars.euiSizeXL} * 2) ${_uiTheme.euiThemeVars.euiSizeM} 0 ${_uiTheme.euiThemeVars.euiSizeM};
`;
const ElasticsearchJavaClientReadme = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FixedHeader, null, /*#__PURE__*/_react.default.createElement(TopFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(IconPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "fullWidth",
    src: _java.default,
    alt: "icon"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.JavaElasticsearch.readme.title",
    defaultMessage: "Elasticsearch Java Client"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(CenterColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "customIntegrations.languageClients.JavaElasticsearch.readme.intro",
      defaultMessage: "Getting started with the Elasticsearch Java Client requires a few steps."
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.JavaElasticsearch.readme.installGradle",
    defaultMessage: "Installation in a Gradle project by using Jackson"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "java",
    isCopyable: true
  }, `dependencies {
    implementation 'co.elastic.clients:elasticsearch-java:8.5.0'
    implementation 'com.fasterxml.jackson.core:jackson-databind:2.12.3'
}`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.JavaElasticsearch.readme.installMaven",
    defaultMessage: "Installation in a Maven project by using Jackson"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.JavaElasticsearch.readme.installMavenMsg",
    defaultMessage: "In the {pom} of your project, add the following repository definition and dependencies:",
    values: {
      pom: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "pom.xml")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "xml",
    isCopyable: true
  }, `<project>
  <dependencies>

    <dependency>
      <groupId>co.elastic.clients</groupId>
      <artifactId>elasticsearch-java</artifactId>
      <version>8.5.0</version>
    </dependency>

    <dependency>
      <groupId>com.fasterxml.jackson.core</groupId>
      <artifactId>jackson-databind</artifactId>
      <version>2.12.3</version>
    </dependency>

  </dependencies>
</project>`)), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.JavaElasticsearch.readme.connecting",
    defaultMessage: "Connecting to Elastic cloud"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.GoElasticsearch.readme.connectingText",
    defaultMessage: "You can connect to Elastic Cloud using an {api_key} and a {cloud_id}:",
    values: {
      api_key: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "API key"),
      cloud_id: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "Cloud ID")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    language: "java"
  }, `// cloudID found in the 'Manage this deployment' page
// apiKey found in the 'Management' page under the section 'Security'

RestClientBuilder builder = RestClient.builder(cloudID);
Header[] defaultHeaders =
    new Header[]{new BasicHeader("Authorization",
        "ApiKey " + apiKey)};
builder.setDefaultHeaders(defaultHeaders);
`)))))));
};
exports.ElasticsearchJavaClientReadme = ElasticsearchJavaClientReadme;