"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProfileService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class UserProfileService {
  constructor(coreContext) {
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "delegate", void 0);
    this.log = coreContext.logger.get('user-profile-service');
  }
  setup() {
    return {
      registerUserProfileDelegate: delegate => {
        if (this.delegate) {
          throw new Error('userProfile API can only be registered once');
        }
        this.delegate = delegate;
      }
    };
  }
  start() {
    var _this$delegate;
    if (!this.delegate) {
      this.log.warn('userProfile API was not registered, using default implementation');
    }
    const apiContract = (_this$delegate = this.delegate) !== null && _this$delegate !== void 0 ? _this$delegate : (0, _utils.getDefaultUserProfileImplementation)();
    return (0, _utils.convertUserProfileAPI)(apiContract);
  }
  stop() {}
}
exports.UserProfileService = UserProfileService;