"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkFipsConfig = checkFipsConfig;
exports.isFipsEnabled = isFipsEnabled;
var _crypto = require("crypto");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function isFipsEnabled(config) {
  var _config$experimental$, _config$experimental, _config$experimental$2;
  return (_config$experimental$ = config === null || config === void 0 ? void 0 : (_config$experimental = config.experimental) === null || _config$experimental === void 0 ? void 0 : (_config$experimental$2 = _config$experimental.fipsMode) === null || _config$experimental$2 === void 0 ? void 0 : _config$experimental$2.enabled) !== null && _config$experimental$ !== void 0 ? _config$experimental$ : false;
}
function checkFipsConfig(config, logger) {
  const isFipsConfigEnabled = isFipsEnabled(config);
  const isNodeRunningWithFipsEnabled = (0, _crypto.getFips)() === 1;

  // Check if FIPS is enabled in either setting
  if (isFipsConfigEnabled || isNodeRunningWithFipsEnabled) {
    // FIPS must be enabled on both or log and error an exit Kibana
    if (isFipsConfigEnabled !== isNodeRunningWithFipsEnabled) {
      logger.error(`Configuration mismatch error. xpack.security.experimental.fipsMode.enabled is set to ${isFipsConfigEnabled} and the configured Node.js environment has FIPS ${isNodeRunningWithFipsEnabled ? 'enabled' : 'disabled'}`);
      process.exit(78);
    } else {
      logger.info('Kibana is running in FIPS mode.');
    }
  }
}