"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreSavedObjectsRouteHandlerContext = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _scopedSavedObjectsClient = /*#__PURE__*/new WeakMap();
var _typeRegistry = /*#__PURE__*/new WeakMap();
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The {@link SavedObjectsRequestHandlerContext} implementation.
 * @internal
 */
class CoreSavedObjectsRouteHandlerContext {
  constructor(savedObjectsStart, request) {
    _classPrivateFieldInitSpec(this, _scopedSavedObjectsClient, void 0);
    _classPrivateFieldInitSpec(this, _typeRegistry, void 0);
    (0, _defineProperty2.default)(this, "getClient", options => {
      if (!options) return this.client;
      return this.savedObjectsStart.getScopedClient(this.request, options);
    });
    (0, _defineProperty2.default)(this, "getExporter", client => {
      return this.savedObjectsStart.createExporter(client);
    });
    (0, _defineProperty2.default)(this, "getImporter", client => {
      return this.savedObjectsStart.createImporter(client);
    });
    this.savedObjectsStart = savedObjectsStart;
    this.request = request;
  }
  get client() {
    if (_classPrivateFieldGet(_scopedSavedObjectsClient, this) == null) {
      _classPrivateFieldSet(_scopedSavedObjectsClient, this, this.savedObjectsStart.getScopedClient(this.request));
    }
    return _classPrivateFieldGet(_scopedSavedObjectsClient, this);
  }
  get typeRegistry() {
    if (_classPrivateFieldGet(_typeRegistry, this) == null) {
      _classPrivateFieldSet(_typeRegistry, this, this.savedObjectsStart.getTypeRegistry());
    }
    return _classPrivateFieldGet(_typeRegistry, this);
  }
}
exports.CoreSavedObjectsRouteHandlerContext = CoreSavedObjectsRouteHandlerContext;