"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const registerGetRoute = (router, {
  config,
  coreUsageData,
  logger,
  access
}) => {
  const {
    allowHttpApiAccess
  } = config;
  router.get({
    path: '/{type}/{id}',
    options: {
      access,
      summary: `Get a saved object`,
      deprecated: true
    },
    validate: {
      params: _configSchema.schema.object({
        type: _configSchema.schema.string(),
        id: _configSchema.schema.string()
      })
    }
  }, (0, _utils.catchAndReturnBoomErrors)(async (context, request, response) => {
    (0, _utils.logWarnOnExternalRequest)({
      method: 'get',
      path: '/api/saved_objects/{type}/{id}',
      request,
      logger
    });
    const {
      type,
      id
    } = request.params;
    const usageStatsClient = coreUsageData.getClient();
    usageStatsClient.incrementSavedObjectsGet({
      request,
      types: [type]
    }).catch(() => {});
    const {
      savedObjects
    } = await context.core;
    if (!allowHttpApiAccess) {
      (0, _utils.throwIfTypeNotVisibleByAPI)(type, savedObjects.typeRegistry);
    }
    const object = await savedObjects.client.get(type, id, {
      migrationVersionCompatibility: 'compatible'
    });
    return response.ok({
      body: object
    });
  }));
};
exports.registerGetRoute = registerGetRoute;