"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyTypeDefaults = void 0;
var _semver = _interopRequireDefault(require("semver"));
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Apply global defaults to the provided SO type.
 */
const applyTypeDefaults = type => {
  let switchToModelVersionAt = type.switchToModelVersionAt;
  if (switchToModelVersionAt) {
    if (!_semver.default.valid(switchToModelVersionAt)) {
      throw new Error(`Type ${type.name}: invalid switchToModelVersionAt provided: ${switchToModelVersionAt}`);
    }
    if (_semver.default.gt(switchToModelVersionAt, _coreSavedObjectsBaseServerInternal.globalSwitchToModelVersionAt)) {
      throw new Error(`Type ${type.name}: provided switchToModelVersionAt (${switchToModelVersionAt}) is higher than maximum (${_coreSavedObjectsBaseServerInternal.globalSwitchToModelVersionAt})`);
    }
  } else {
    switchToModelVersionAt = _coreSavedObjectsBaseServerInternal.globalSwitchToModelVersionAt;
  }
  return {
    ...type,
    switchToModelVersionAt
  };
};
exports.applyTypeDefaults = applyTypeDefaults;