"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupUnknownAndExcludedDocsWaitForTask = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _retry_state = require("../../../model/retry_state");
var _actions = require("../../actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const cleanupUnknownAndExcludedDocsWaitForTask = (state, res, context) => {
  if (Either.isLeft(res)) {
    if ((0, _actions.isTypeof)(res.left, 'wait_for_task_completion_timeout')) {
      // After waiting for the specified timeout, the task has not yet
      // completed. Retry this step to see if the task has completed after an
      // exponential delay.  We will basically keep polling forever until the
      // Elasticsearch task succeeds or fails.
      return (0, _retry_state.delayRetryState)(state, res.left.message, Number.MAX_SAFE_INTEGER);
    } else {
      if (state.retryCount < context.maxRetryAttempts) {
        const retryCount = state.retryCount + 1;
        const retryDelay = 1500 + 1000 * Math.random();
        return {
          ...state,
          controlState: 'CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS',
          hasDeletedDocs: true,
          retryCount,
          retryDelay,
          logs: [...state.logs, {
            level: 'warning',
            message: `Errors occurred whilst deleting unwanted documents. Retrying attempt ${retryCount}.`
          }]
        };
      } else {
        var _res$left$versionConf;
        const failures = res.left.failures.length;
        const versionConflicts = (_res$left$versionConf = res.left.versionConflicts) !== null && _res$left$versionConf !== void 0 ? _res$left$versionConf : 0;
        let reason = `Migration failed because it was unable to delete unwanted documents from the ${state.currentIndex} system index (${failures} failures and ${versionConflicts} conflicts)`;
        if (failures) {
          reason += `:\n` + res.left.failures.map(failure => `- ${failure}\n`).join('');
        }
        return {
          ...state,
          controlState: 'FATAL',
          reason
        };
      }
    }
  }
  const mustRefresh = state.hasDeletedDocs || typeof res.right.deleted === 'undefined' || res.right.deleted > 0;
  if (mustRefresh) {
    return {
      ...state,
      controlState: 'CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS_REFRESH'
    };
  } else {
    return {
      ...state,
      controlState: 'OUTDATED_DOCUMENTS_SEARCH_OPEN_PIT'
    };
  }
};
exports.cleanupUnknownAndExcludedDocsWaitForTask = cleanupUnknownAndExcludedDocsWaitForTask;