"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVersionAddedMappings = exports.getVersionAddedFields = void 0;
var _lodash = require("lodash");
var _get_field_list = require("../utils/get_field_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Return the mappings that were introduced in the given version.
 * If multiple 'mappings_addition' changes are present for the version,
 * they will be deep-merged.
 */
const getVersionAddedMappings = version => {
  const mappingChanges = version.changes.filter(change => change.type === 'mappings_addition');
  return (0, _lodash.merge)({}, ...mappingChanges.map(change => change.addedMappings));
};

/**
 * Return the list of fields, sorted, that were introduced in the given version.
 */
exports.getVersionAddedMappings = getVersionAddedMappings;
const getVersionAddedFields = version => {
  const addedMappings = getVersionAddedMappings(version);
  return (0, _get_field_list.getFieldListFromTypeMapping)({
    properties: addedMappings
  });
};
exports.getVersionAddedFields = getVersionAddedFields;