"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRepositoryHelpers = void 0;
var _helpers = require("../apis/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createRepositoryHelpers = ({
  logger,
  extensions,
  index,
  client,
  typeRegistry,
  serializer,
  migrator,
  createPointInTimeFinder
}) => {
  const commonHelper = new _helpers.CommonHelper({
    spaceExtension: extensions === null || extensions === void 0 ? void 0 : extensions.spacesExtension,
    encryptionExtension: extensions === null || extensions === void 0 ? void 0 : extensions.encryptionExtension,
    createPointInTimeFinder,
    defaultIndex: index,
    kibanaVersion: migrator.kibanaVersion,
    registry: typeRegistry
  });
  const encryptionHelper = new _helpers.EncryptionHelper({
    encryptionExtension: extensions === null || extensions === void 0 ? void 0 : extensions.encryptionExtension,
    securityExtension: extensions === null || extensions === void 0 ? void 0 : extensions.securityExtension
  });
  const validationHelper = new _helpers.ValidationHelper({
    registry: typeRegistry,
    logger,
    kibanaVersion: migrator.kibanaVersion
  });
  const preflightCheckHelper = new _helpers.PreflightCheckHelper({
    getIndexForType: commonHelper.getIndexForType.bind(commonHelper),
    createPointInTimeFinder: commonHelper.createPointInTimeFinder.bind(commonHelper),
    serializer,
    registry: typeRegistry,
    client
  });
  const serializerHelper = new _helpers.SerializerHelper({
    registry: typeRegistry,
    serializer
  });
  const migrationHelper = new _helpers.MigrationHelper({
    migrator,
    encryptionHelper
  });
  const userHelper = new _helpers.UserHelper({
    securityExtension: extensions === null || extensions === void 0 ? void 0 : extensions.securityExtension
  });
  const helpers = {
    common: commonHelper,
    preflight: preflightCheckHelper,
    validation: validationHelper,
    encryption: encryptionHelper,
    serializer: serializerHelper,
    migration: migrationHelper,
    user: userHelper
  };
  return helpers;
};
exports.createRepositoryHelpers = createRepositoryHelpers;