"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeForUpdate = void 0;
var _lodash = require("lodash");
var _saferLodashSet = require("@kbn/safer-lodash-set");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const mergeForUpdate = ({
  targetAttributes,
  updatedAttributes,
  typeMappings
}) => {
  const rootMappings = {
    properties: typeMappings.properties
  };
  return recursiveMerge(targetAttributes, updatedAttributes, [], rootMappings);
};
exports.mergeForUpdate = mergeForUpdate;
const recursiveMerge = (target, value, keys, mappings) => {
  if (shouldRecursiveMerge(value, mappings)) {
    for (const [subKey, subVal] of Object.entries(value)) {
      recursiveMerge(target, subVal, [...keys, subKey], getFieldMapping(mappings, subKey));
    }
  } else if (keys.length > 0 && value !== undefined) {
    (0, _saferLodashSet.set)(target, keys, value);
  }
  return target;
};
const getFieldMapping = (parentMapping, fieldName) => {
  if (parentMapping && 'properties' in parentMapping) {
    var _parentMapping$proper;
    return (_parentMapping$proper = parentMapping.properties) === null || _parentMapping$proper === void 0 ? void 0 : _parentMapping$proper[fieldName];
  }
  return undefined;
};
const shouldRecursiveMerge = (value, mappings) => {
  if (mappings && 'type' in mappings && mappings.type === 'flattened') {
    return false;
  }
  if ((0, _lodash.isPlainObject)(value) && Object.keys(value).length > 0) {
    return true;
  }
  return false;
};