"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.right = exports.left = exports.isRight = exports.isLeft = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Discriminated union (TypeScript approximation of an algebraic data type); this design pattern is used for internal repository operations.
 * @internal
 */

/**
 * Left part of discriminated union ({@link Either}).
 * @internal
 */

/**
 * Right part of discriminated union ({@link Either}).
 * @internal
 */

/**
 * Returns a {@link Left} part holding the provided value.
 * @internal
 */
const left = value => ({
  tag: 'Left',
  value
});

/**
 * Returns a {@link Right} part holding the provided value.
 * @internal
 */
exports.left = left;
const right = value => ({
  tag: 'Right',
  value
});

/**
 * Type guard for left part of discriminated union ({@link Left}, {@link Either}).
 * @internal
 */
exports.right = right;
const isLeft = either => either.tag === 'Left';
/**
 * Type guard for right part of discriminated union ({@link Right}, {@link Either}).
 * @internal
 */
exports.isLeft = isLeft;
const isRight = either => either.tag === 'Right';
exports.isRight = isRight;