"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommonHelper = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class CommonHelper {
  constructor({
    registry,
    createPointInTimeFinder,
    spaceExtension,
    encryptionExtension,
    kibanaVersion,
    defaultIndex
  }) {
    (0, _defineProperty2.default)(this, "registry", void 0);
    (0, _defineProperty2.default)(this, "spaceExtension", void 0);
    (0, _defineProperty2.default)(this, "encryptionExtension", void 0);
    (0, _defineProperty2.default)(this, "defaultIndex", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "createPointInTimeFinder", void 0);
    this.registry = registry;
    this.spaceExtension = spaceExtension;
    this.encryptionExtension = encryptionExtension;
    this.kibanaVersion = kibanaVersion;
    this.defaultIndex = defaultIndex;
    this.createPointInTimeFinder = createPointInTimeFinder;
  }

  /**
   * Returns index specified by the given type or the default index
   *
   * @param type - the type
   */
  getIndexForType(type) {
    return (0, _coreSavedObjectsBaseServerInternal.getIndexForType)({
      type,
      defaultIndex: this.defaultIndex,
      typeRegistry: this.registry,
      kibanaVersion: this.kibanaVersion
    });
  }

  /**
   * Returns an array of indices as specified in `this._registry` for each of the
   * given `types`. If any of the types don't have an associated index, the
   * default index `this._index` will be included.
   *
   * @param types The types whose indices should be retrieved
   */
  getIndicesForTypes(types) {
    return unique(types.map(t => this.getIndexForType(t)));
  }

  /**
   * {@inheritDoc ISavedObjectsRepository.getCurrentNamespace}
   */
  getCurrentNamespace(namespace) {
    if (this.spaceExtension) {
      return this.spaceExtension.getCurrentNamespace(namespace);
    }
    return (0, _utils.normalizeNamespace)(namespace);
  }

  /**
   * Saved objects with encrypted attributes should have IDs that are hard to guess, especially since IDs are part of the AAD used during
   * encryption, that's why we control them within this function and don't allow consumers to specify their own IDs directly for encryptable
   * types unless overwriting the original document.
   */
  getValidId(type, id, version, overwrite) {
    var _this$encryptionExten;
    if (!((_this$encryptionExten = this.encryptionExtension) !== null && _this$encryptionExten !== void 0 && _this$encryptionExten.isEncryptableType(type))) {
      return id || _coreSavedObjectsUtilsServer.SavedObjectsUtils.generateId();
    }
    if (!id) {
      return _coreSavedObjectsUtilsServer.SavedObjectsUtils.generateId();
    }
    // only allow a specified ID if we're overwriting an existing ESO with a Version
    // this helps us ensure that the document really was previously created using ESO
    // and not being used to get around the specified ID limitation
    const canSpecifyID = overwrite && version || _coreSavedObjectsUtilsServer.SavedObjectsUtils.isRandomId(id);
    if (!canSpecifyID) {
      throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createBadRequestError('Predefined IDs are not allowed for saved objects with encrypted attributes unless the ID is a UUID.');
    }
    return id;
  }
}
exports.CommonHelper = CommonHelper;
const unique = array => [...new Set(array)];