"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performGet = void 0;
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const performGet = async ({
  type,
  id,
  options
}, {
  registry,
  helpers,
  allowedTypes,
  client,
  serializer,
  extensions = {}
}) => {
  var _body$_source$namespa, _body$_source;
  const {
    common: commonHelper,
    migration: migrationHelper
  } = helpers;
  const {
    securityExtension
  } = extensions;
  const namespace = commonHelper.getCurrentNamespace(options.namespace);
  const {
    migrationVersionCompatibility
  } = options;
  if (!allowedTypes.includes(type)) {
    throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createGenericNotFoundError(type, id);
  }
  const {
    body,
    statusCode,
    headers
  } = await client.get({
    id: serializer.generateRawId(namespace, type, id),
    index: commonHelper.getIndexForType(type)
  }, {
    ignore: [404],
    meta: true
  });
  const indexNotFound = statusCode === 404;
  // check if we have the elasticsearch header when index is not found and, if we do, ensure it is from Elasticsearch
  if (indexNotFound && !(0, _coreElasticsearchServerInternal.isSupportedEsServer)(headers)) {
    throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createGenericNotFoundEsUnavailableError(type, id);
  }
  const objectNotFound = !(0, _utils.isFoundGetResponse)(body) || indexNotFound || !(0, _utils.rawDocExistsInNamespace)(registry, body, namespace);
  const authorizationResult = await (securityExtension === null || securityExtension === void 0 ? void 0 : securityExtension.authorizeGet({
    namespace,
    object: {
      type,
      id,
      existingNamespaces: (_body$_source$namespa = body === null || body === void 0 ? void 0 : (_body$_source = body._source) === null || _body$_source === void 0 ? void 0 : _body$_source.namespaces) !== null && _body$_source$namespa !== void 0 ? _body$_source$namespa : []
    },
    objectNotFound
  }));
  if (objectNotFound) {
    // see "404s from missing index" above
    throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createGenericNotFoundError(type, id);
  }
  const document = (0, _utils.getSavedObjectFromSource)(registry, type, id, body, {
    migrationVersionCompatibility
  });
  return await migrationHelper.migrateAndDecryptStorageDocument({
    document,
    typeMap: authorizationResult === null || authorizationResult === void 0 ? void 0 : authorizationResult.typeMap
  });
};
exports.performGet = performGet;