"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performCollectMultiNamespaceReferences = void 0;
var _collect_multi_namespace_references = require("./internals/collect_multi_namespace_references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const performCollectMultiNamespaceReferences = async ({
  objects,
  options
}, {
  registry,
  helpers,
  allowedTypes,
  client,
  serializer,
  extensions = {}
}) => {
  const {
    common: commonHelper
  } = helpers;
  const {
    securityExtension
  } = extensions;
  const namespace = commonHelper.getCurrentNamespace(options.namespace);
  return (0, _collect_multi_namespace_references.collectMultiNamespaceReferences)({
    registry,
    allowedTypes,
    client,
    serializer,
    getIndexForType: commonHelper.getIndexForType.bind(commonHelper),
    createPointInTimeFinder: commonHelper.createPointInTimeFinder.bind(commonHelper),
    securityExtension,
    objects,
    options: {
      ...options,
      namespace
    }
  });
};
exports.performCollectMultiNamespaceReferences = performCollectMultiNamespaceReferences;