"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderingService = void 0;
var _react = _interopRequireDefault(require("react"));
var _server = require("react-dom/server");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
var _views = require("./views");
var _bootstrap = require("./bootstrap");
var _render_utils = require("./render_utils");
var _filter_ui_plugins = require("./filter_ui_plugins");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const themeVersion = 'v8';

/** @internal */
class RenderingService {
  constructor(coreContext) {
    this.coreContext = coreContext;
  }
  async preboot({
    http,
    uiPlugins,
    i18n
  }) {
    http.registerRoutes('', router => {
      (0, _bootstrap.registerBootstrapRoute)({
        router,
        renderer: (0, _bootstrap.bootstrapRendererFactory)({
          uiPlugins,
          baseHref: http.staticAssets.getHrefBase(),
          packageInfo: this.coreContext.env.packageInfo,
          auth: http.auth
        })
      });
    });
    return {
      render: this.render.bind(this, {
        http,
        uiPlugins,
        i18n
      })
    };
  }
  async setup({
    elasticsearch,
    http,
    status,
    uiPlugins,
    customBranding,
    userSettings,
    i18n
  }) {
    (0, _bootstrap.registerBootstrapRoute)({
      router: http.createRouter(''),
      renderer: (0, _bootstrap.bootstrapRendererFactory)({
        uiPlugins,
        baseHref: http.staticAssets.getHrefBase(),
        packageInfo: this.coreContext.env.packageInfo,
        auth: http.auth,
        userSettingsService: userSettings
      })
    });
    return {
      render: this.render.bind(this, {
        elasticsearch,
        http,
        uiPlugins,
        status,
        customBranding,
        userSettings,
        i18n
      })
    };
  }
  async render(renderOptions, request, uiSettings, {
    isAnonymousPage = false,
    vars,
    includeExposedConfigKeys
  } = {}) {
    var _uiSettings$client$ge, _uiSettings$client2, _uiSettings$globalCli2, _uiSettings$globalCli3, _settings$user$theme, _settings$user$theme2, _branding, _branding2, _branding3, _branding4, _status$isStatusPageA, _branding5, _branding6, _branding7;
    const {
      elasticsearch,
      http,
      uiPlugins,
      status,
      customBranding,
      userSettings,
      i18n
    } = renderOptions;
    const env = {
      mode: this.coreContext.env.mode,
      packageInfo: this.coreContext.env.packageInfo
    };
    const staticAssetsHrefBase = http.staticAssets.getHrefBase();
    const usingCdn = http.staticAssets.isUsingCdn();
    const basePath = http.basePath.get(request);
    const {
      serverBasePath,
      publicBaseUrl
    } = http.basePath;
    let settingsUserValues = {};
    let globalSettingsUserValues = {};
    if (!isAnonymousPage) {
      var _uiSettings$client, _uiSettings$globalCli;
      const userValues = await Promise.all([(_uiSettings$client = uiSettings.client) === null || _uiSettings$client === void 0 ? void 0 : _uiSettings$client.getUserProvided(), (_uiSettings$globalCli = uiSettings.globalClient) === null || _uiSettings$globalCli === void 0 ? void 0 : _uiSettings$globalCli.getUserProvided()]);
      settingsUserValues = userValues[0];
      globalSettingsUserValues = userValues[1];
    }
    const settings = {
      defaults: (_uiSettings$client$ge = (_uiSettings$client2 = uiSettings.client) === null || _uiSettings$client2 === void 0 ? void 0 : _uiSettings$client2.getRegistered()) !== null && _uiSettings$client$ge !== void 0 ? _uiSettings$client$ge : {},
      user: settingsUserValues
    };
    const globalSettings = {
      defaults: (_uiSettings$globalCli2 = (_uiSettings$globalCli3 = uiSettings.globalClient) === null || _uiSettings$globalCli3 === void 0 ? void 0 : _uiSettings$globalCli3.getRegistered()) !== null && _uiSettings$globalCli2 !== void 0 ? _uiSettings$globalCli2 : {},
      user: globalSettingsUserValues
    };
    let clusterInfo = {};
    let branding = {};
    try {
      // Only provide the clusterInfo if the request is authenticated and the elasticsearch service is available.
      const authenticated = isAuthenticated(http.auth, request);
      if (authenticated && elasticsearch) {
        clusterInfo = await (0, _rxjs.firstValueFrom)(elasticsearch.clusterInfo$.pipe((0, _rxjs.timeout)(50),
        // If not available, just return undefined
        (0, _rxjs.catchError)(() => (0, _rxjs.of)({}))));
      }
      branding = await (customBranding === null || customBranding === void 0 ? void 0 : customBranding.getBrandingFor(request, {
        unauthenticated: !authenticated
      }));
    } catch (err) {
      // swallow error
    }

    // dark mode
    const userSettingDarkMode = isAnonymousPage ? undefined : await (userSettings === null || userSettings === void 0 ? void 0 : userSettings.getUserSettingDarkMode(request));
    const isThemeOverridden = (_settings$user$theme = (_settings$user$theme2 = settings.user['theme:darkMode']) === null || _settings$user$theme2 === void 0 ? void 0 : _settings$user$theme2.isOverridden) !== null && _settings$user$theme !== void 0 ? _settings$user$theme : false;
    let darkMode;
    if (userSettingDarkMode !== undefined && !isThemeOverridden) {
      darkMode = userSettingDarkMode;
    } else {
      darkMode = (0, _render_utils.getSettingValue)('theme:darkMode', settings, _coreUiSettingsCommon.parseDarkModeValue);
    }
    const themeStylesheetPaths = mode => (0, _render_utils.getThemeStylesheetPaths)({
      darkMode: mode,
      themeVersion,
      baseHref: staticAssetsHrefBase
    });
    const commonStylesheetPaths = (0, _render_utils.getCommonStylesheetPaths)({
      baseHref: staticAssetsHrefBase
    });
    const scriptPaths = (0, _render_utils.getScriptPaths)({
      darkMode,
      baseHref: staticAssetsHrefBase
    });
    const loggingConfig = await (0, _render_utils.getBrowserLoggingConfig)(this.coreContext.configService);
    const locale = _i18n.i18n.getLocale();
    let translationsUrl;
    if (usingCdn) {
      translationsUrl = `${staticAssetsHrefBase}/translations/${locale}.json`;
    } else {
      const translationHash = i18n.getTranslationHash();
      translationsUrl = `${serverBasePath}/translations/${translationHash}/${locale}.json`;
    }
    const filteredPlugins = (0, _filter_ui_plugins.filterUiPlugins)({
      uiPlugins,
      isAnonymousPage
    });
    const bootstrapScript = isAnonymousPage ? 'bootstrap-anonymous.js' : 'bootstrap.js';
    const metadata = {
      strictCsp: http.csp.strict,
      uiPublicUrl: `${staticAssetsHrefBase}/ui`,
      bootstrapScriptUrl: `${basePath}/${bootstrapScript}`,
      i18n: _i18n.i18n.translate,
      locale,
      themeVersion,
      darkMode,
      stylesheetPaths: commonStylesheetPaths,
      scriptPaths,
      customBranding: {
        faviconSVG: (_branding = branding) === null || _branding === void 0 ? void 0 : _branding.faviconSVG,
        faviconPNG: (_branding2 = branding) === null || _branding2 === void 0 ? void 0 : _branding2.faviconPNG,
        pageTitle: (_branding3 = branding) === null || _branding3 === void 0 ? void 0 : _branding3.pageTitle,
        logo: (_branding4 = branding) === null || _branding4 === void 0 ? void 0 : _branding4.logo
      },
      injectedMetadata: {
        version: env.packageInfo.version,
        buildNumber: env.packageInfo.buildNum,
        branch: env.packageInfo.branch,
        basePath,
        serverBasePath,
        publicBaseUrl,
        assetsHrefBase: staticAssetsHrefBase,
        logging: loggingConfig,
        env,
        clusterInfo,
        anonymousStatusPage: (_status$isStatusPageA = status === null || status === void 0 ? void 0 : status.isStatusPageAnonymous()) !== null && _status$isStatusPageA !== void 0 ? _status$isStatusPageA : false,
        i18n: {
          translationsUrl
        },
        theme: {
          darkMode,
          version: themeVersion,
          stylesheetPaths: {
            default: themeStylesheetPaths(false),
            dark: themeStylesheetPaths(true)
          }
        },
        customBranding: {
          logo: (_branding5 = branding) === null || _branding5 === void 0 ? void 0 : _branding5.logo,
          customizedLogo: (_branding6 = branding) === null || _branding6 === void 0 ? void 0 : _branding6.customizedLogo,
          pageTitle: (_branding7 = branding) === null || _branding7 === void 0 ? void 0 : _branding7.pageTitle
        },
        csp: {
          warnLegacyBrowsers: http.csp.warnLegacyBrowsers
        },
        externalUrl: http.externalUrl,
        vars: vars !== null && vars !== void 0 ? vars : {},
        uiPlugins: await Promise.all(filteredPlugins.map(async ([id, plugin]) => {
          const {
            browserConfig,
            exposedConfigKeys
          } = await getUiConfig(uiPlugins, id);
          return {
            id,
            plugin,
            config: browserConfig,
            ...(includeExposedConfigKeys && {
              exposedConfigKeys
            })
          };
        })),
        legacyMetadata: {
          uiSettings: settings,
          globalUiSettings: globalSettings
        }
      }
    };
    return `<!DOCTYPE html>${(0, _server.renderToStaticMarkup)( /*#__PURE__*/_react.default.createElement(_views.Template, {
      metadata: metadata
    }))}`;
  }
  async stop() {}
}
exports.RenderingService = RenderingService;
const getUiConfig = async (uiPlugins, pluginId) => {
  var _await$browserConfig$;
  const browserConfig = uiPlugins.browserConfigs.get(pluginId);
  return (_await$browserConfig$ = await (browserConfig === null || browserConfig === void 0 ? void 0 : browserConfig.pipe((0, _rxjs.take)(1)).toPromise())) !== null && _await$browserConfig$ !== void 0 ? _await$browserConfig$ : {
    browserConfig: {},
    exposedConfigKeys: {}
  };
};
const isAuthenticated = (auth, request) => {
  const {
    status: authStatus
  } = auth.get(request);
  // status is 'unknown' when auth is disabled. we just need to not be `unauthenticated` here.
  return authStatus !== 'unauthenticated';
};