"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTranslationsRoute = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MINUTE = 60;
const HOUR = 60 * MINUTE;
const DAY = 24 * HOUR;
const registerTranslationsRoute = ({
  router,
  locale,
  translationHash,
  isDist
}) => {
  let translationCache;
  ['/translations/{locale}.json', `/translations/${translationHash}/{locale}.json`].forEach(routePath => {
    router.get({
      path: routePath,
      validate: {
        params: _configSchema.schema.object({
          locale: _configSchema.schema.string()
        })
      },
      options: {
        access: 'public',
        authRequired: false
      }
    }, (ctx, req, res) => {
      if (req.params.locale.toLowerCase() !== locale.toLowerCase()) {
        return res.notFound({
          body: `Unknown locale: ${req.params.locale}`
        });
      }
      if (!translationCache) {
        const translations = JSON.stringify(_i18n.i18n.getTranslation());
        translationCache = {
          translations,
          hash: translationHash
        };
      }
      let headers;
      if (isDist) {
        headers = {
          'content-type': 'application/json',
          'cache-control': `public, max-age=${365 * DAY}, immutable`
        };
      } else {
        headers = {
          'content-type': 'application/json',
          'cache-control': 'must-revalidate',
          etag: translationCache.hash
        };
      }
      return res.ok({
        headers,
        body: translationCache.translations
      });
    });
  });
};
exports.registerTranslationsRoute = registerTranslationsRoute;