"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _config = require("./config");
var _csp_directives = require("./csp_directives");
var _CspConfig;
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const DEFAULT_CONFIG = Object.freeze(_config.cspConfig.schema.validate({}));

/**
 * CSP configuration for use in Kibana.
 * @public
 */
var _directives = /*#__PURE__*/new WeakMap();
class CspConfig {
  /**
   * Returns the default CSP configuration when passed with no config
   * @internal
   */
  constructor(rawCspConfig, ...moreConfigs) {
    _classPrivateFieldInitSpec(this, _directives, void 0);
    (0, _defineProperty2.default)(this, "strict", void 0);
    (0, _defineProperty2.default)(this, "disableUnsafeEval", void 0);
    (0, _defineProperty2.default)(this, "warnLegacyBrowsers", void 0);
    (0, _defineProperty2.default)(this, "disableEmbedding", void 0);
    (0, _defineProperty2.default)(this, "header", void 0);
    (0, _defineProperty2.default)(this, "reportOnlyHeader", void 0);
    _classPrivateFieldSet(_directives, this, _csp_directives.CspDirectives.fromConfig(rawCspConfig, ...moreConfigs));
    if (rawCspConfig.disableEmbedding) {
      _classPrivateFieldGet(_directives, this).clearDirectiveValues('frame-ancestors');
      _classPrivateFieldGet(_directives, this).addDirectiveValue('frame-ancestors', `'self'`);
    }
    const {
      enforceHeader,
      reportOnlyHeader
    } = _classPrivateFieldGet(_directives, this).getCspHeadersByDisposition();
    this.header = enforceHeader;
    this.reportOnlyHeader = reportOnlyHeader;
    this.strict = rawCspConfig.strict;
    this.disableUnsafeEval = rawCspConfig.disableUnsafeEval;
    this.warnLegacyBrowsers = rawCspConfig.warnLegacyBrowsers;
    this.disableEmbedding = rawCspConfig.disableEmbedding;
  }
}
exports.CspConfig = CspConfig;
_CspConfig = CspConfig;
(0, _defineProperty2.default)(CspConfig, "DEFAULT", new _CspConfig(DEFAULT_CONFIG));