"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectResponseHeaders = injectResponseHeaders;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @note mutates the response object
 * @internal
 */
function injectResponseHeaders(headers, response) {
  const mutableResponse = response;
  mutableResponse.options = {
    ...mutableResponse.options,
    headers: {
      ...mutableResponse.options.headers,
      ...headers
    }
  };
  return mutableResponse;
}