"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareResponseValidation = prepareResponseValidation;
exports.prepareRouteConfigValidation = prepareRouteConfigValidation;
var _lodash = require("lodash");
var _coreHttpServer = require("@kbn/core-http-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function isStatusCode(key) {
  return !isNaN(parseInt(key, 10));
}
function prepareResponseValidation(validation) {
  const responses = Object.entries(validation).map(([key, value]) => {
    if (isStatusCode(key)) {
      return [key, {
        body: (0, _lodash.once)(value.body)
      }];
    }
    return [key, value];
  });
  return Object.fromEntries(responses);
}
function prepareValidation(validator) {
  if ((0, _coreHttpServer.isFullValidatorContainer)(validator) && validator.response) {
    return {
      ...validator,
      response: prepareResponseValidation(validator.response)
    };
  }
  return validator;
}

// Integration tested in ./routes.test.ts
function prepareRouteConfigValidation(config) {
  // Calculating schema validation can be expensive so when it is provided lazily
  // we only want to instantiate it once. This also provides idempotency guarantees
  if (typeof config.validate === 'function') {
    const validate = config.validate;
    return {
      ...config,
      validate: (0, _lodash.once)(() => prepareValidation(validate()))
    };
  } else if (typeof config.validate === 'object' && typeof config.validate !== null) {
    return {
      ...config,
      validate: prepareValidation(config.validate)
    };
  }
  return config;
}