"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeSliderReducers = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const timeSliderReducers = exports.timeSliderReducers = {
  publishValue: (state, action) => {
    state.output.timeslice = action.payload.value;
  },
  setTimeRangeBounds: (state, action) => {
    state.componentState.format = action.payload.format;
    state.componentState.stepSize = action.payload.stepSize;
    state.componentState.ticks = action.payload.ticks;
    state.componentState.timeRangeBounds = action.payload.timeRangeBounds;
  },
  setValueAsPercentageOfTimeRange: (state, action) => {
    state.explicitInput.timesliceStartAsPercentageOfTimeRange = action.payload.timesliceStartAsPercentageOfTimeRange;
    state.explicitInput.timesliceEndAsPercentageOfTimeRange = action.payload.timesliceEndAsPercentageOfTimeRange;
  },
  setValue: (state, action) => {
    state.componentState.value = action.payload.value;
  },
  setRange: (state, action) => {
    state.componentState.range = action.payload.range;
  },
  setIsAnchored: (state, action) => {
    state.explicitInput.isAnchored = action.payload.isAnchored;
  },
  setIsOpen: (state, action) => {
    state.componentState.isOpen = action.payload.isOpen;
  }
};