"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderSlidingWindowRange = TimeSliderSlidingWindowRange;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function TimeSliderSlidingWindowRange(props) {
  function onChange(value) {
    props.onChange(value);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDualRange, {
    fullWidth: true,
    value: props.value,
    onChange: onChange,
    showTicks: true,
    min: props.timeRangeMin,
    max: props.timeRangeMax,
    step: props.stepSize,
    ticks: props.ticks,
    isDraggable: true
  });
}