"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderPrepend = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/embeddable-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _control_group_container = require("../../control_group/embeddable/control_group_container");
var _time_slider_embeddable = require("../embeddable/time_slider_embeddable");
var _time_slider_strings = require("./time_slider_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TimeSliderPrepend = props => {
  const timeSlider = (0, _time_slider_embeddable.useTimeSlider)();
  const controlGroup = (0, _control_group_container.useControlGroupContainer)();
  const showApplySelectionsButton = controlGroup.select(state => state.explicitInput.showApplySelections);
  const viewMode = controlGroup.select(state => state.explicitInput.viewMode);
  const [isPaused, setIsPaused] = (0, _react.useState)(true);
  const [timeoutId, setTimeoutId] = (0, _react.useState)(undefined);
  const [subscription, setSubscription] = (0, _react.useState)(undefined);
  const playNextFrame = (0, _react.useCallback)(() => {
    // advance to next frame
    props.onNext();
    if (props.waitForControlOutputConsumersToLoad$) {
      const nextFrameSubscription = props.waitForControlOutputConsumersToLoad$.pipe((0, _rxjs.first)()).subscribe(() => {
        // use timeout to display frame for small time period before moving to next frame
        const nextTimeoutId = window.setTimeout(() => {
          playNextFrame();
        }, 1750);
        setTimeoutId(nextTimeoutId);
      });
      setSubscription(nextFrameSubscription);
    }
  }, [props]);
  const onPlay = (0, _react.useCallback)(() => {
    timeSlider.dispatch.setIsOpen({
      isOpen: true
    });
    setIsPaused(false);
    playNextFrame();
  }, [timeSlider.dispatch, playNextFrame]);
  const onPause = (0, _react.useCallback)(() => {
    timeSlider.dispatch.setIsOpen({
      isOpen: true
    });
    setIsPaused(true);
    if (subscription) {
      subscription.unsubscribe();
      setSubscription(undefined);
    }
    if (timeoutId) {
      clearTimeout(timeoutId);
      setTimeoutId(undefined);
    }
  }, [timeSlider.dispatch, subscription, timeoutId]);
  const PlayButton = (0, _react.useMemo)(() => {
    const Button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      className: "timeSlider-playToggle",
      onClick: isPaused ? onPlay : onPause,
      disabled: showApplySelectionsButton,
      iconType: isPaused ? 'playFilled' : 'pause',
      size: "s",
      display: "fill",
      "aria-label": _time_slider_strings.TimeSliderStrings.control.getPlayButtonAriaLabel(isPaused)
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showApplySelectionsButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _time_slider_strings.TimeSliderStrings.control.getPlayButtonDisabledTooltip()
    }, Button) : Button);
  }, [isPaused, onPlay, onPause, showApplySelectionsButton]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      onPause();
      props.onPrevious();
    },
    iconType: "framePrevious",
    color: "text",
    "aria-label": _time_slider_strings.TimeSliderStrings.control.getPreviousButtonAriaLabel(),
    "data-test-subj": "timeSlider-previousTimeWindow"
  }), props.waitForControlOutputConsumersToLoad$ === undefined || showApplySelectionsButton && viewMode === _common.ViewMode.VIEW ? null : PlayButton, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      onPause();
      props.onNext();
    },
    iconType: "frameNext",
    color: "text",
    "aria-label": _time_slider_strings.TimeSliderStrings.control.getNextButtonAriaLabel(),
    "data-test-subj": "timeSlider-nextTimeWindow"
  }));
};
exports.TimeSliderPrepend = TimeSliderPrepend;