"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.optionsListServiceFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class OptionsListService {
  constructor(core, requiredServices) {
    (0, _defineProperty2.default)(this, "core", void 0);
    (0, _defineProperty2.default)(this, "data", void 0);
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "getRoundedTimeRange", timeRange => ({
      from: _datemath.default.parse(timeRange.from).startOf('minute').toISOString(),
      to: _datemath.default.parse(timeRange.to).endOf('minute').toISOString()
    }));
    (0, _defineProperty2.default)(this, "optionsListCacheResolver", request => {
      const {
        size,
        sort,
        query,
        filters,
        timeRange,
        searchString,
        runPastTimeout,
        selectedOptions,
        searchTechnique,
        field: {
          name: fieldName
        },
        dataView: {
          title: dataViewTitle
        }
      } = request;
      return [...(timeRange ? JSON.stringify(this.getRoundedTimeRange(timeRange)) : []),
      // round timeRange to the minute to avoid cache misses
      Math.floor(Date.now() / 1000 / 60), // Only cache results for a minute in case data changes in ES index
      selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.join(','), JSON.stringify(filters), JSON.stringify(query), JSON.stringify(sort), searchTechnique, runPastTimeout, dataViewTitle, searchString, fieldName, size].join('|');
    });
    (0, _defineProperty2.default)(this, "cachedOptionsListRequest", (0, _lodash.memoize)(async (request, abortSignal) => {
      const index = request.dataView.title;
      const requestBody = this.getRequestBody(request);
      return await this.http.fetch(`/internal/controls/optionsList/${index}`, {
        version: '1',
        body: JSON.stringify(requestBody),
        signal: abortSignal,
        method: 'POST'
      });
    }, this.optionsListCacheResolver));
    (0, _defineProperty2.default)(this, "getRequestBody", request => {
      const timeService = this.data.query.timefilter.timefilter;
      const {
        query,
        filters,
        dataView,
        timeRange,
        field,
        ...passThroughProps
      } = request;
      const timeFilter = timeRange ? timeService.createFilter(dataView, timeRange) : undefined;
      const filtersToUse = [...(filters !== null && filters !== void 0 ? filters : []), ...(timeFilter ? [timeFilter] : [])];
      const config = (0, _common.getEsQueryConfig)(this.core.uiSettings);
      const esFilters = [(0, _esQuery.buildEsQuery)(dataView, query !== null && query !== void 0 ? query : [], filtersToUse !== null && filtersToUse !== void 0 ? filtersToUse : [], config)];
      return {
        ...passThroughProps,
        filters: esFilters,
        fieldName: field.name,
        fieldSpec: field,
        runtimeFieldMap: dataView.toSpec().runtimeFieldMap
      };
    });
    (0, _defineProperty2.default)(this, "cachedAllowExpensiveQueries", (0, _lodash.memoize)(async () => {
      const {
        allowExpensiveQueries
      } = await this.http.get('/internal/controls/optionsList/getExpensiveQueriesSetting', {
        version: '1'
      });
      return allowExpensiveQueries;
    }));
    (0, _defineProperty2.default)(this, "getAllowExpensiveQueries", async () => {
      try {
        return await this.cachedAllowExpensiveQueries();
      } catch (error) {
        return false;
      }
    });
    (0, _defineProperty2.default)(this, "optionsListResponseWasFailure", response => {
      return response.error !== undefined;
    });
    (0, _defineProperty2.default)(this, "runOptionsListRequest", async (request, abortSignal) => {
      try {
        return await this.cachedOptionsListRequest(request, abortSignal);
      } catch (error) {
        // Remove rejected results from memoize cache
        this.cachedOptionsListRequest.cache.delete(this.optionsListCacheResolver(request));
        if (error.name === 'AbortError') return {
          error: 'aborted'
        };
        return {
          error
        };
      }
    });
    (0, _defineProperty2.default)(this, "clearOptionsListCache", () => {
      this.cachedOptionsListRequest.cache = new _lodash.memoize.Cache();
    });
    this.core = core;
    ({
      data: this.data,
      http: this.http
    } = requiredServices);
  }
}
const optionsListServiceFactory = (startParams, requiredServices) => {
  return new OptionsListService(startParams.coreStart, requiredServices);
};
exports.optionsListServiceFactory = optionsListServiceFactory;