"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRangeSlider = exports.RangeSliderEmbeddable = exports.RangeSliderControlContext = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _ = require("../..");
var _services = require("../../services");
var _range_slider_control = require("../components/range_slider_control");
var _range_slider_reducers = require("../range_slider_reducers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const diffDataFetchProps = (current, last) => {
  if (!current || !last) return false;
  const {
    filters: currentFilters,
    ...currentWithoutFilters
  } = current;
  const {
    filters: lastFilters,
    ...lastWithoutFilters
  } = last;
  if (!(0, _fastDeepEqual.default)(currentWithoutFilters, lastWithoutFilters)) return false;
  if (!(0, _esQuery.compareFilters)(lastFilters !== null && lastFilters !== void 0 ? lastFilters : [], currentFilters !== null && currentFilters !== void 0 ? currentFilters : [], _esQuery.COMPARE_ALL_OPTIONS)) return false;
  return true;
};
const RangeSliderControlContext = exports.RangeSliderControlContext = /*#__PURE__*/(0, _react.createContext)(null);
const useRangeSlider = () => {
  const rangeSlider = (0, _react.useContext)(RangeSliderControlContext);
  if (rangeSlider == null) {
    throw new Error('useRangeSlider must be used inside RangeSliderControlContext.');
  }
  return rangeSlider;
};
exports.useRangeSlider = useRangeSlider;
class RangeSliderEmbeddable extends _public.Embeddable {
  constructor(reduxToolsPackage, _input, output, parent) {
    super(_input, output, parent); // get filters for initial output...
    (0, _defineProperty2.default)(this, "type", _.RANGE_SLIDER_CONTROL);
    (0, _defineProperty2.default)(this, "deferEmbeddableLoad", true);
    (0, _defineProperty2.default)(this, "parent", void 0);
    (0, _defineProperty2.default)(this, "subscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "node", void 0);
    // Controls services
    (0, _defineProperty2.default)(this, "dataService", void 0);
    (0, _defineProperty2.default)(this, "dataViewsService", void 0);
    // Internal data fetching state for this input control.
    (0, _defineProperty2.default)(this, "dataView", void 0);
    (0, _defineProperty2.default)(this, "field", void 0);
    // state management
    (0, _defineProperty2.default)(this, "select", void 0);
    (0, _defineProperty2.default)(this, "getState", void 0);
    (0, _defineProperty2.default)(this, "dispatch", void 0);
    (0, _defineProperty2.default)(this, "onStateChange", void 0);
    (0, _defineProperty2.default)(this, "cleanupStateTools", void 0);
    (0, _defineProperty2.default)(this, "initialize", async () => {
      var _this$getInput$value;
      const [initialMin, initialMax] = (_this$getInput$value = this.getInput().value) !== null && _this$getInput$value !== void 0 ? _this$getInput$value : [];
      if (!(0, _lodash.isEmpty)(initialMin) || !(0, _lodash.isEmpty)(initialMax)) {
        const {
          filters: rangeFilter
        } = await this.buildFilter();
        this.dispatch.publishFilters(rangeFilter);
      }
      this.setInitializationFinished();
      this.runRangeSliderQuery().then(async () => {
        this.setupSubscriptions();
      }).catch(e => this.onLoadingError(e.message));
    });
    (0, _defineProperty2.default)(this, "setupSubscriptions", () => {
      const dataFetchPipe = this.getInput$().pipe((0, _rxjs.map)(newInput => {
        var _newInput$ignoreParen;
        return {
          validate: !Boolean((_newInput$ignoreParen = newInput.ignoreParentSettings) === null || _newInput$ignoreParen === void 0 ? void 0 : _newInput$ignoreParen.ignoreValidations),
          lastReloadRequestTime: newInput.lastReloadRequestTime,
          dataViewId: newInput.dataViewId,
          fieldName: newInput.fieldName,
          timeRange: newInput.timeRange,
          timeslice: newInput.timeslice,
          filters: newInput.filters,
          query: newInput.query
        };
      }), (0, _rxjs.distinctUntilChanged)(diffDataFetchProps));
      const valueChangePipe = this.getInput$().pipe((0, _rxjs.distinctUntilChanged)((a, b) => {
        var _a$value, _b$value;
        return (0, _lodash.isEqual)((_a$value = a.value) !== null && _a$value !== void 0 ? _a$value : ['', ''], (_b$value = b.value) !== null && _b$value !== void 0 ? _b$value : ['', '']);
      }));
      this.subscriptions.add(dataFetchPipe.pipe((0, _rxjs.switchMap)(async () => {
        try {
          this.dispatch.setLoading(true);
          await this.runRangeSliderQuery();
          await this.runValidations();
          this.dispatch.setLoading(false);
        } catch (e) {
          this.onLoadingError(e.message);
        }
      })).subscribe());

      // publish filters when value changes
      this.subscriptions.add(valueChangePipe.pipe((0, _rxjs.switchMap)(async () => {
        try {
          this.dispatch.setLoading(true);
          const {
            filters: rangeFilter
          } = await this.buildFilter();
          this.dispatch.publishFilters(rangeFilter);
          await this.runValidations();
          this.dispatch.setLoading(false);
        } catch (e) {
          this.onLoadingError(e.message);
        }
      })).subscribe());
    });
    (0, _defineProperty2.default)(this, "getCurrentDataViewAndField", async () => {
      const {
        explicitInput: {
          dataViewId,
          fieldName
        }
      } = this.getState();
      if (!this.dataView || this.dataView.id !== dataViewId) {
        try {
          this.dataView = await this.dataViewsService.get(dataViewId);
          this.dispatch.setDataViewId(this.dataView.id);
        } catch (e) {
          this.onLoadingError(e.message);
        }
      }
      if (this.dataView && (!this.field || this.field.name !== fieldName)) {
        this.field = this.dataView.getFieldByName(fieldName);
        if (this.field) {
          var _this$field;
          this.dispatch.setField((_this$field = this.field) === null || _this$field === void 0 ? void 0 : _this$field.toSpec());
        } else {
          this.onLoadingError(_i18n.i18n.translate('controls.rangeSlider.errors.fieldNotFound', {
            defaultMessage: 'Could not locate field: {fieldName}',
            values: {
              fieldName
            }
          }));
        }
      }
      return {
        dataView: this.dataView,
        field: this.field
      };
    });
    (0, _defineProperty2.default)(this, "runRangeSliderQuery", async () => {
      const {
        dataView,
        field
      } = await this.getCurrentDataViewAndField();
      if (!dataView || !field) return;
      const {
        min,
        max
      } = await this.fetchMinMax({
        dataView,
        field
      });
      (0, _reactRedux.batch)(() => {
        this.dispatch.setMinMax({
          min,
          max
        });
        this.dispatch.setDataViewId(dataView.id);
        this.dispatch.setErrorMessage(undefined);
      });
    });
    (0, _defineProperty2.default)(this, "fetchMinMax", async ({
      dataView,
      field
    }) => {
      const {
        query
      } = this.getInput();
      const searchSource = await this.dataService.searchSource.create();
      searchSource.setField('size', 0);
      searchSource.setField('index', dataView);
      searchSource.setField('filter', this.getGlobalFilters(dataView));
      if (query) {
        searchSource.setField('query', query);
      }
      const aggBody = {};
      if (field) {
        if (field.scripted) {
          aggBody.script = {
            source: field.script,
            lang: field.lang
          };
        } else {
          aggBody.field = field.name;
        }
      }
      const aggs = {
        maxAgg: {
          max: aggBody
        },
        minAgg: {
          min: aggBody
        }
      };
      searchSource.setField('aggs', aggs);
      const resp = await (0, _rxjs.lastValueFrom)(searchSource.fetch$());
      const min = (0, _lodash.get)(resp, 'rawResponse.aggregations.minAgg.value');
      const max = (0, _lodash.get)(resp, 'rawResponse.aggregations.maxAgg.value');
      return {
        min,
        max
      };
    });
    (0, _defineProperty2.default)(this, "selectionsToFilters", async input => {
      const {
        value
      } = input;
      const [selectedMin, selectedMax] = value !== null && value !== void 0 ? value : ['', ''];
      const [min, max] = [selectedMin, selectedMax].map(parseFloat);
      const {
        dataView,
        field
      } = await this.getCurrentDataViewAndField();
      if (!dataView || !field || (0, _lodash.isEmpty)(selectedMin) && (0, _lodash.isEmpty)(selectedMax)) {
        return {
          filters: []
        };
      }
      const params = {};
      if (selectedMin) {
        params.gte = min;
      }
      if (selectedMax) {
        params.lte = max;
      }
      const rangeFilter = (0, _esQuery.buildRangeFilter)(field, params, dataView);
      rangeFilter.meta.key = field === null || field === void 0 ? void 0 : field.name;
      rangeFilter.meta.type = 'range';
      rangeFilter.meta.params = params;
      return {
        filters: [rangeFilter]
      };
    });
    (0, _defineProperty2.default)(this, "buildFilter", async () => {
      const {
        explicitInput: {
          value
        }
      } = this.getState();
      return await this.selectionsToFilters({
        value
      });
    });
    (0, _defineProperty2.default)(this, "getGlobalFilters", dataView => {
      const {
        filters: globalFilters,
        ignoreParentSettings,
        timeRange: globalTimeRange,
        timeslice
      } = this.getInput();
      const filters = [];
      if (!(ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreFilters) && globalFilters) {
        filters.push(...globalFilters);
      }
      const timeRange = timeslice !== undefined ? {
        from: new Date(timeslice[0]).toISOString(),
        to: new Date(timeslice[1]).toISOString(),
        mode: 'absolute'
      } : globalTimeRange;
      if (!(ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreTimerange) && timeRange) {
        const timeFilter = this.dataService.timefilter.createFilter(dataView, timeRange);
        if (timeFilter) filters.push(timeFilter);
      }
      return filters;
    });
    (0, _defineProperty2.default)(this, "runValidations", async () => {
      const {
        dataView
      } = await this.getCurrentDataViewAndField();
      if (!dataView) return;
      // Check if new range filter results in no data
      const {
        ignoreParentSettings,
        query
      } = this.getInput();
      if (ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreValidations) {
        this.dispatch.setIsInvalid(false);
      } else {
        var _resp$rawResponse, _resp$rawResponse$hit;
        const searchSource = await this.dataService.searchSource.create();
        const {
          filters: rangeFilters = []
        } = this.getOutput();
        const filters = this.getGlobalFilters(dataView).concat(rangeFilters);
        searchSource.setField('size', 0);
        searchSource.setField('index', dataView);
        searchSource.setField('filter', filters);
        if (query) {
          searchSource.setField('query', query);
        }
        const resp = await (0, _rxjs.lastValueFrom)(searchSource.fetch$());
        const total = resp === null || resp === void 0 ? void 0 : (_resp$rawResponse = resp.rawResponse) === null || _resp$rawResponse === void 0 ? void 0 : (_resp$rawResponse$hit = _resp$rawResponse.hits) === null || _resp$rawResponse$hit === void 0 ? void 0 : _resp$rawResponse$hit.total;
        const docCount = typeof total === 'number' ? total : total === null || total === void 0 ? void 0 : total.value;
        const {
          explicitInput: {
            value
          }
        } = this.getState();
        this.reportInvalidSelections(!value || value[0] === '' && value[1] === '' ? false : !docCount // don't set the range slider invalid if it has no selections
        );
      }
    });
    (0, _defineProperty2.default)(this, "reportInvalidSelections", hasInvalidSelections => {
      var _this$parent;
      this.dispatch.setIsInvalid(hasInvalidSelections);
      (_this$parent = this.parent) === null || _this$parent === void 0 ? void 0 : _this$parent.reportInvalidSelections({
        id: this.id,
        hasInvalidSelections
      });
    });
    (0, _defineProperty2.default)(this, "reload", async () => {
      this.dispatch.setLoading(true);
      try {
        await this.runRangeSliderQuery();
        this.dispatch.setLoading(false);
      } catch (e) {
        this.onLoadingError(e.message);
      }
    });
    (0, _defineProperty2.default)(this, "destroy", () => {
      super.destroy();
      this.cleanupStateTools();
      this.subscriptions.unsubscribe();
    });
    (0, _defineProperty2.default)(this, "render", node => {
      if (this.node) {
        _reactDom.default.unmountComponentAtNode(this.node);
      }
      this.node = node;
      const ControlsServicesProvider = _services.pluginServices.getContextProvider();
      _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, _services.pluginServices.getServices().core, /*#__PURE__*/_react.default.createElement(ControlsServicesProvider, null, /*#__PURE__*/_react.default.createElement(RangeSliderControlContext.Provider, {
        value: this
      }, /*#__PURE__*/_react.default.createElement(_range_slider_control.RangeSliderControl, null)))), node);
    });
    this.parent = parent;

    // Destructure controls services
    ({
      data: this.dataService,
      dataViews: this.dataViewsService
    } = _services.pluginServices.getServices());
    const reduxEmbeddableTools = reduxToolsPackage.createReduxEmbeddableTools({
      embeddable: this,
      reducers: _range_slider_reducers.rangeSliderReducers,
      initialComponentState: (0, _range_slider_reducers.getDefaultComponentState)()
    });
    this.select = reduxEmbeddableTools.select;
    this.getState = reduxEmbeddableTools.getState;
    this.dispatch = reduxEmbeddableTools.dispatch;
    this.onStateChange = reduxEmbeddableTools.onStateChange;
    this.cleanupStateTools = reduxEmbeddableTools.cleanup;
    this.initialize();
  }
  onLoadingError(errorMessage) {
    (0, _reactRedux.batch)(() => {
      this.dispatch.setLoading(false);
      this.dispatch.publishFilters([]);
      this.dispatch.setErrorMessage(errorMessage);
    });
  }
  clearSelections() {
    this.dispatch.setSelectedRange(['', '']);
  }
  isChained() {
    return true;
  }
}
exports.RangeSliderEmbeddable = RangeSliderEmbeddable;