"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOptionsList = exports.OptionsListEmbeddableContext = exports.OptionsListEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _ = require("../..");
var _services = require("../../services");
var _options_list_control = require("../components/options_list_control");
var _options_list_reducers = require("../options_list_reducers");
var _types = require("../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const diffDataFetchProps = (last, current) => {
  if (!current || !last) return false;
  const {
    filters: currentFilters,
    ...currentWithoutFilters
  } = current;
  const {
    filters: lastFilters,
    ...lastWithoutFilters
  } = last;
  if (!(0, _fastDeepEqual.default)(currentWithoutFilters, lastWithoutFilters)) return false;
  if (!(0, _esQuery.compareFilters)(lastFilters !== null && lastFilters !== void 0 ? lastFilters : [], currentFilters !== null && currentFilters !== void 0 ? currentFilters : [], _esQuery.COMPARE_ALL_OPTIONS)) return false;
  return true;
};
const OptionsListEmbeddableContext = exports.OptionsListEmbeddableContext = /*#__PURE__*/(0, _react.createContext)(null);
const useOptionsList = () => {
  const optionsList = (0, _react.useContext)(OptionsListEmbeddableContext);
  if (optionsList == null) {
    throw new Error('useOptionsList must be used inside OptionsListEmbeddableContext.');
  }
  return optionsList;
};
exports.useOptionsList = useOptionsList;
class OptionsListEmbeddable extends _public.Embeddable {
  constructor(reduxToolsPackage, _input, output, parent) {
    super(_input, output, parent);
    (0, _defineProperty2.default)(this, "type", _.OPTIONS_LIST_CONTROL);
    (0, _defineProperty2.default)(this, "deferEmbeddableLoad", true);
    (0, _defineProperty2.default)(this, "parent", void 0);
    (0, _defineProperty2.default)(this, "subscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "node", void 0);
    // Controls services
    (0, _defineProperty2.default)(this, "dataViewsService", void 0);
    (0, _defineProperty2.default)(this, "optionsListService", void 0);
    // Internal data fetching state for this input control.
    (0, _defineProperty2.default)(this, "typeaheadSubject", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "loadMoreSubject", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "abortController", void 0);
    (0, _defineProperty2.default)(this, "dataView", void 0);
    (0, _defineProperty2.default)(this, "field", void 0);
    // state management
    (0, _defineProperty2.default)(this, "select", void 0);
    (0, _defineProperty2.default)(this, "getState", void 0);
    (0, _defineProperty2.default)(this, "dispatch", void 0);
    (0, _defineProperty2.default)(this, "onStateChange", void 0);
    (0, _defineProperty2.default)(this, "cleanupStateTools", void 0);
    (0, _defineProperty2.default)(this, "initialize", async () => {
      const {
        selectedOptions: initialSelectedOptions
      } = this.getInput();
      if (initialSelectedOptions) {
        const {
          explicitInput: {
            existsSelected,
            exclude
          }
        } = this.getState();
        const {
          filters
        } = await this.selectionsToFilters({
          existsSelected,
          exclude,
          selectedOptions: initialSelectedOptions
        });
        this.dispatch.publishFilters(filters);
      }
      this.setInitializationFinished();
      this.dispatch.setAllowExpensiveQueries(await this.optionsListService.getAllowExpensiveQueries());
      this.runOptionsListQuery().then(async () => {
        this.setupSubscriptions();
      });
    });
    (0, _defineProperty2.default)(this, "setupSubscriptions", () => {
      const dataFetchPipe = this.getInput$().pipe((0, _rxjs.map)(newInput => {
        var _newInput$ignoreParen;
        return {
          validate: !Boolean((_newInput$ignoreParen = newInput.ignoreParentSettings) === null || _newInput$ignoreParen === void 0 ? void 0 : _newInput$ignoreParen.ignoreValidations),
          lastReloadRequestTime: newInput.lastReloadRequestTime,
          existsSelected: newInput.existsSelected,
          searchTechnique: newInput.searchTechnique,
          dataViewId: newInput.dataViewId,
          fieldName: newInput.fieldName,
          timeRange: newInput.timeRange,
          timeslice: newInput.timeslice,
          exclude: newInput.exclude,
          filters: newInput.filters,
          query: newInput.query,
          sort: newInput.sort
        };
      }), (0, _rxjs.distinctUntilChanged)(diffDataFetchProps));

      // debounce typeahead pipe to slow down search string related queries
      const typeaheadPipe = this.typeaheadSubject.pipe((0, _rxjs.debounceTime)(100));
      const loadMorePipe = this.loadMoreSubject.pipe((0, _rxjs.debounceTime)(100));

      // fetch available options when input changes or when search string has changed
      this.subscriptions.add((0, _rxjs.merge)(dataFetchPipe, typeaheadPipe).pipe((0, _rxjs.skip)(1)) // Skip the first input update because options list query will be run by initialize.
      .subscribe(() => {
        this.runOptionsListQuery();
      }));

      // fetch more options when reaching the bottom of the available options
      this.subscriptions.add(loadMorePipe.subscribe(size => {
        this.runOptionsListQuery(size);
      }));

      /**
       * when input selectedOptions changes, check all selectedOptions against the latest value of invalidSelections, and publish filter
       **/
      this.subscriptions.add(this.getInput$().pipe((0, _rxjs.distinctUntilChanged)((a, b) => a.exclude === b.exclude && a.existsSelected === b.existsSelected && (0, _lodash.isEqual)(a.selectedOptions, b.selectedOptions)), (0, _rxjs.tap)(({
        selectedOptions: newSelectedOptions
      }) => {
        if (!newSelectedOptions || (0, _lodash.isEmpty)(newSelectedOptions)) {
          this.dispatch.clearValidAndInvalidSelections({});
        } else {
          var _this$getState$compon;
          const {
            invalidSelections
          } = (_this$getState$compon = this.getState().componentState) !== null && _this$getState$compon !== void 0 ? _this$getState$compon : {};
          const newValidSelections = [];
          const newInvalidSelections = [];
          for (const selectedOption of newSelectedOptions) {
            if (invalidSelections !== null && invalidSelections !== void 0 && invalidSelections.includes(selectedOption)) {
              newInvalidSelections.push(selectedOption);
              continue;
            }
            newValidSelections.push(selectedOption);
          }
          this.dispatch.setValidAndInvalidSelections({
            validSelections: newValidSelections,
            invalidSelections: newInvalidSelections
          });
        }
      }), (0, _rxjs.switchMap)(async () => {
        const {
          filters: newFilters
        } = await this.buildFilter();
        this.dispatch.publishFilters(newFilters);
      })).subscribe());
    });
    (0, _defineProperty2.default)(this, "getCurrentDataViewAndField", async () => {
      const {
        explicitInput: {
          dataViewId,
          fieldName
        }
      } = this.getState();
      if (!this.dataView || this.dataView.id !== dataViewId) {
        var _this$dataView;
        try {
          this.dataView = await this.dataViewsService.get(dataViewId);
        } catch (e) {
          this.dispatch.setErrorMessage(e.message);
        }
        this.dispatch.setDataViewId((_this$dataView = this.dataView) === null || _this$dataView === void 0 ? void 0 : _this$dataView.id);
      }
      if (this.dataView && (!this.field || this.field.name !== fieldName)) {
        const field = this.dataView.getFieldByName(fieldName);
        if (field) {
          this.field = field.toSpec();
          this.dispatch.setField(this.field);
        } else {
          this.dispatch.setErrorMessage(_i18n.i18n.translate('controls.optionsList.errors.fieldNotFound', {
            defaultMessage: 'Could not locate field: {fieldName}',
            values: {
              fieldName
            }
          }));
        }
      }
      return {
        dataView: this.dataView,
        field: this.field
      };
    });
    (0, _defineProperty2.default)(this, "runOptionsListQuery", async (size = _types.MIN_OPTIONS_LIST_REQUEST_SIZE) => {
      var _this$field;
      const previousFieldName = (_this$field = this.field) === null || _this$field === void 0 ? void 0 : _this$field.name;
      const {
        dataView,
        field
      } = await this.getCurrentDataViewAndField();
      if (!dataView || !field) return;
      if (previousFieldName && field.name !== previousFieldName) {
        this.dispatch.setSearchString('');
      }
      const {
        componentState: {
          searchString,
          allowExpensiveQueries
        },
        explicitInput: {
          selectedOptions,
          runPastTimeout,
          existsSelected,
          sort,
          searchTechnique
        }
      } = this.getState();
      this.dispatch.setLoading(true);
      if (searchString.valid) {
        // need to get filters, query, ignoreParentSettings, and timeRange from input for inheritance
        const {
          ignoreParentSettings,
          filters,
          query,
          timeRange: globalTimeRange,
          timeslice
        } = this.getInput();
        if (this.abortController) this.abortController.abort();
        this.abortController = new AbortController();
        const timeRange = timeslice !== undefined ? {
          from: new Date(timeslice[0]).toISOString(),
          to: new Date(timeslice[1]).toISOString(),
          mode: 'absolute'
        } : globalTimeRange;
        const response = await this.optionsListService.runOptionsListRequest({
          sort,
          size,
          field,
          query,
          filters,
          dataView,
          timeRange,
          searchTechnique,
          runPastTimeout,
          selectedOptions,
          allowExpensiveQueries,
          searchString: searchString.value
        }, this.abortController.signal);
        if (this.optionsListService.optionsListResponseWasFailure(response)) {
          if (response.error === 'aborted') {
            // This prevents an aborted request (which can happen, for example, when a user types a search string too quickly)
            // from prematurely setting loading to `false` and updating the suggestions to show "No results"
            return;
          }
          this.dispatch.setErrorMessage(response.error.message);
          return;
        }
        const {
          suggestions,
          invalidSelections,
          totalCardinality
        } = response;
        if (!selectedOptions && !existsSelected || (0, _lodash.isEmpty)(invalidSelections) || ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreValidations) {
          this.dispatch.updateQueryResults({
            availableOptions: suggestions,
            invalidSelections: undefined,
            validSelections: selectedOptions,
            totalCardinality
          });
          this.reportInvalidSelections(false);
        } else {
          const valid = [];
          const invalid = [];
          for (const selectedOption of selectedOptions !== null && selectedOptions !== void 0 ? selectedOptions : []) {
            if (invalidSelections !== null && invalidSelections !== void 0 && invalidSelections.includes(selectedOption)) invalid.push(selectedOption);else valid.push(selectedOption);
          }
          this.dispatch.updateQueryResults({
            availableOptions: suggestions,
            invalidSelections: invalid,
            validSelections: valid,
            totalCardinality
          });
          this.reportInvalidSelections(true);
        }
        (0, _reactRedux.batch)(() => {
          this.dispatch.setErrorMessage(undefined);
          this.dispatch.setLoading(false);
        });
      } else {
        (0, _reactRedux.batch)(() => {
          this.dispatch.setErrorMessage(undefined);
          this.dispatch.updateQueryResults({
            availableOptions: []
          });
          this.dispatch.setLoading(false);
        });
      }
    });
    (0, _defineProperty2.default)(this, "reportInvalidSelections", hasInvalidSelections => {
      var _this$parent;
      (_this$parent = this.parent) === null || _this$parent === void 0 ? void 0 : _this$parent.reportInvalidSelections({
        id: this.id,
        hasInvalidSelections
      });
    });
    (0, _defineProperty2.default)(this, "selectionsToFilters", async input => {
      const {
        existsSelected,
        exclude,
        selectedOptions
      } = input;
      if ((!selectedOptions || (0, _lodash.isEmpty)(selectedOptions)) && !existsSelected) {
        return {
          filters: []
        };
      }
      const {
        dataView,
        field
      } = await this.getCurrentDataViewAndField();
      if (!dataView || !field) return {
        filters: []
      };
      let newFilter;
      if (existsSelected) {
        newFilter = (0, _esQuery.buildExistsFilter)(field, dataView);
      } else if (selectedOptions) {
        if (selectedOptions.length === 1) {
          newFilter = (0, _esQuery.buildPhraseFilter)(field, selectedOptions[0], dataView);
        } else {
          newFilter = (0, _esQuery.buildPhrasesFilter)(field, selectedOptions, dataView);
        }
      }
      if (!newFilter) return {
        filters: []
      };
      newFilter.meta.key = field === null || field === void 0 ? void 0 : field.name;
      if (exclude) newFilter.meta.negate = true;
      return {
        filters: [newFilter]
      };
    });
    (0, _defineProperty2.default)(this, "buildFilter", async () => {
      const {
        explicitInput: {
          existsSelected,
          exclude,
          selectedOptions
        }
      } = this.getState();
      return await this.selectionsToFilters({
        existsSelected,
        exclude,
        selectedOptions
      });
    });
    (0, _defineProperty2.default)(this, "reload", () => {
      // clear cache when reload is requested
      this.optionsListService.clearOptionsListCache();
      this.runOptionsListQuery();
    });
    (0, _defineProperty2.default)(this, "destroy", () => {
      var _this$abortController;
      super.destroy();
      this.cleanupStateTools();
      (_this$abortController = this.abortController) === null || _this$abortController === void 0 ? void 0 : _this$abortController.abort();
      this.subscriptions.unsubscribe();
      if (this.node) _reactDom.default.unmountComponentAtNode(this.node);
    });
    (0, _defineProperty2.default)(this, "render", node => {
      if (this.node) {
        _reactDom.default.unmountComponentAtNode(this.node);
      }
      this.node = node;
      _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, _services.pluginServices.getServices().core, /*#__PURE__*/_react.default.createElement(OptionsListEmbeddableContext.Provider, {
        value: this
      }, /*#__PURE__*/_react.default.createElement(_options_list_control.OptionsListControl, {
        typeaheadSubject: this.typeaheadSubject,
        loadMoreSubject: this.loadMoreSubject
      }))), node);
    });
    this.parent = parent;

    // Destructure controls services
    ({
      dataViews: this.dataViewsService,
      optionsList: this.optionsListService
    } = _services.pluginServices.getServices());
    this.typeaheadSubject = new _rxjs.Subject();
    this.loadMoreSubject = new _rxjs.Subject();

    // build redux embeddable tools
    const reduxEmbeddableTools = reduxToolsPackage.createReduxEmbeddableTools({
      embeddable: this,
      reducers: _options_list_reducers.optionsListReducers,
      initialComponentState: (0, _options_list_reducers.getDefaultComponentState)()
    });
    this.select = reduxEmbeddableTools.select;
    this.getState = reduxEmbeddableTools.getState;
    this.dispatch = reduxEmbeddableTools.dispatch;
    this.cleanupStateTools = reduxEmbeddableTools.cleanup;
    this.onStateChange = reduxEmbeddableTools.onStateChange;
    this.initialize();
  }
  clearSelections() {
    this.dispatch.clearSelections({});
    this.reportInvalidSelections(false);
  }
  isChained() {
    return true;
  }
}
exports.OptionsListEmbeddable = OptionsListEmbeddable;